/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class JDBCLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(JDBCLoginService.class);
    protected String _config;
    protected String _jdbcDriver;
    protected String _url;
    protected String _userName;
    protected String _password;
    protected String _userTableKey;
    protected String _userTablePasswordField;
    protected String _roleTableRoleField;
    protected int _cacheTime;
    protected long _lastHashPurge;
    protected Connection _con;
    protected String _userSql;
    protected String _roleSql;

    public JDBCLoginService() {
    }

    public JDBCLoginService(String string) {
        this.setName(string);
    }

    public JDBCLoginService(String string, String string2) {
        this.setName(string);
        this.setConfig(string2);
    }

    public JDBCLoginService(String string, IdentityService identityService, String string2) {
        this.setName(string);
        this.setIdentityService(identityService);
        this.setConfig(string2);
    }

    @Override
    protected void doStart() {
        Properties properties = new Properties();
        Resource resource = Resource.newResource((String)this._config);
        Object object = resource.getInputStream();
        Object object2 = null;
        try {
            properties.load((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        object = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        object2 = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        String string = properties.getProperty("roletable");
        String string2 = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        String string3 = properties.getProperty("userroletable");
        String string4 = properties.getProperty("userroletableuserkey");
        String string5 = properties.getProperty("userroletablerolekey");
        this._cacheTime = new Integer(properties.getProperty("cachetime"));
        if (this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) {
            LOG.warn("UserRealm " + this.getName() + " has not been properly configured", new Object[0]);
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + (String)object + " where " + (String)object2 + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + string + " r, " + string3 + " u where u." + string4 + " = ?" + " and r." + string2 + " = u." + string5;
        Loader.loadClass(this.getClass(), (String)this._jdbcDriver).newInstance();
        super.doStart();
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = string;
    }

    public void connectDatabase() {
        try {
            Class.forName(this._jdbcDriver);
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException sQLException) {
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)classNotFoundException);
        }
    }

    @Override
    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        long l = System.currentTimeMillis();
        if (l - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
            this._users.clear();
            this._lastHashPurge = l;
            this.closeConnection();
        }
        return super.login(string, object, servletRequest);
    }

    @Override
    protected void loadUsers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    protected UserIdentity loadUser(String string) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            try (PreparedStatement preparedStatement = this._con.prepareStatement(this._userSql);){
                preparedStatement.setObject(1, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) return null;
                    int n = resultSet.getInt(this._userTableKey);
                    String string2 = resultSet.getString(this._userTablePasswordField);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try (PreparedStatement preparedStatement2 = this._con.prepareStatement(this._roleSql);){
                        preparedStatement2.setInt(1, n);
                        try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                            while (resultSet2.next()) {
                                arrayList.add(resultSet2.getString(this._roleTableRoleField));
                            }
                        }
                    }
                    preparedStatement2 = this.putUser(string, Credential.getCredential((String)string2), arrayList.toArray(new String[arrayList.size()]));
                    return preparedStatement2;
                }
            }
        }
        catch (SQLException sQLException) {
            LOG.warn("UserRealm " + this.getName() + " could not load user information from database", (Throwable)sQLException);
            this.closeConnection();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MappedLoginService.KnownUser loadUserInfo(String string) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            try (PreparedStatement preparedStatement = this._con.prepareStatement(this._userSql);){
                preparedStatement.setObject(1, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) return null;
                    int n = resultSet.getInt(this._userTableKey);
                    String string2 = resultSet.getString(this._userTablePasswordField);
                    JDBCKnownUser jDBCKnownUser = new JDBCKnownUser(string, Credential.getCredential((String)string2), n);
                    return jDBCKnownUser;
                }
            }
        }
        catch (SQLException sQLException) {
            LOG.warn("UserRealm " + this.getName() + " could not load user information from database", (Throwable)sQLException);
            this.closeConnection();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] loadRoleInfo(MappedLoginService.KnownUser var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeConnection() {
        if (this._con != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing db connection for JDBCUserRealm", new Object[0]);
            }
            try {
                this._con.close();
            }
            catch (Exception exception) {
                LOG.ignore((Throwable)exception);
            }
        }
        this._con = null;
    }

    public class JDBCKnownUser
    extends MappedLoginService.KnownUser {
        int _userKey;

        public JDBCKnownUser(String string, Credential credential, int n) {
            super(string, credential);
            this._userKey = n;
        }

        public int getUserKey() {
            return this._userKey;
        }
    }
}

