/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class HashLoginService
extends MappedLoginService
implements PropertyUserStore.UserListener {
    private static final Logger LOG = Log.getLogger(HashLoginService.class);
    private PropertyUserStore _propertyUserStore;
    private String _config;
    private Resource _configResource;
    private boolean hotReload = false;

    public HashLoginService() {
    }

    public HashLoginService(String string) {
        this.setName(string);
    }

    public HashLoginService(String string, String string2) {
        this.setName(string);
        this.setConfig(string2);
    }

    public String getConfig() {
        return this._config;
    }

    public void getConfig(String string) {
        this._config = string;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String string) {
        this._config = string;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    public void setHotReload(boolean bl) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = bl;
    }

    @Deprecated
    public void setRefreshInterval(int n) {
    }

    @Deprecated
    public int getRefreshInterval() {
        return this.hotReload ? 1 : 0;
    }

    @Override
    protected UserIdentity loadUser(String string) {
        return null;
    }

    @Override
    public void loadUsers() {
    }

    @Override
    protected String[] loadRoleInfo(MappedLoginService.KnownUser knownUser) {
        UserIdentity userIdentity = this._propertyUserStore.getUserIdentity(knownUser.getName());
        if (userIdentity == null) {
            return null;
        }
        Set<MappedLoginService.RolePrincipal> set = userIdentity.getSubject().getPrincipals(MappedLoginService.RolePrincipal.class);
        if (set == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MappedLoginService.RolePrincipal rolePrincipal : set) {
            arrayList.add(rolePrincipal.getName());
        }
        return arrayList.toArray(new String[set.size()]);
    }

    @Override
    protected MappedLoginService.KnownUser loadUserInfo(String string) {
        UserIdentity userIdentity = this._propertyUserStore.getUserIdentity(string);
        if (userIdentity != null) {
            return (MappedLoginService.KnownUser)userIdentity.getUserPrincipal();
        }
        return null;
    }

    @Override
    protected void doStart() {
        super.doStart();
        if (this._propertyUserStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doStart: Starting new PropertyUserStore. PropertiesFile: " + this._config + " hotReload: " + this.hotReload, new Object[0]);
            }
            this._propertyUserStore = new PropertyUserStore();
            this._propertyUserStore.setHotReload(this.hotReload);
            this._propertyUserStore.setConfigPath(this._config);
            this._propertyUserStore.registerUserListener(this);
            this._propertyUserStore.start();
        }
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this._propertyUserStore != null) {
            this._propertyUserStore.stop();
        }
        this._propertyUserStore = null;
    }

    @Override
    public void update(String string, Credential credential, String[] stringArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("update: " + string + " Roles: " + stringArray.length, new Object[0]);
        }
    }

    @Override
    public void remove(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + string, new Object[0]);
        }
        this.removeUser(string);
    }

    public class HashKnownUser
    extends MappedLoginService.KnownUser {
        String[] _roles;

        public HashKnownUser(String string, Credential credential) {
            super(string, credential);
        }

        public void setRoles(String[] stringArray) {
            this._roles = stringArray;
        }

        public String[] getRoles() {
            return this._roles;
        }
    }
}

