/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import javax.servlet.ServletContext;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Server;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    LoginService _loginService;

    @Override
    public Authenticator getAuthenticator(Server server, ServletContext servletContext, Authenticator.AuthConfiguration authConfiguration, IdentityService identityService, LoginService loginService) {
        String string = authConfiguration.getAuthMethod();
        LoginAuthenticator loginAuthenticator = null;
        if (string == null || "BASIC".equalsIgnoreCase(string)) {
            loginAuthenticator = new BasicAuthenticator();
        } else if ("DIGEST".equalsIgnoreCase(string)) {
            loginAuthenticator = new DigestAuthenticator();
        } else if ("FORM".equalsIgnoreCase(string)) {
            loginAuthenticator = new FormAuthenticator();
        } else if ("SPNEGO".equalsIgnoreCase(string)) {
            loginAuthenticator = new SpnegoAuthenticator();
        } else if ("NEGOTIATE".equalsIgnoreCase(string)) {
            loginAuthenticator = new SpnegoAuthenticator("NEGOTIATE");
        }
        if ("CLIENT_CERT".equalsIgnoreCase(string) || "CLIENT-CERT".equalsIgnoreCase(string)) {
            loginAuthenticator = new ClientCertAuthenticator();
        }
        return loginAuthenticator;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }
}

