/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletRequest;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Constraint;

public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private static final Logger LOG = Log.getLogger(SecurityHandler.class);
    private static final String OMISSION_SUFFIX = ".omission";
    private static final String ALL_METHODS = "*";
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private final PathMap<Map<String, RoleInfo>> _constraintMap = new PathMap();
    private boolean _denyUncoveredMethods = false;

    public static Constraint createConstraint() {
        return new Constraint();
    }

    public static Constraint createConstraint(Constraint constraint) {
        try {
            return (Constraint)constraint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public static Constraint createConstraint(String string, boolean bl, String[] stringArray, int n) {
        Constraint constraint = ConstraintSecurityHandler.createConstraint();
        if (string != null) {
            constraint.setName(string);
        }
        constraint.setAuthenticate(bl);
        constraint.setRoles(stringArray);
        constraint.setDataConstraint(n);
        return constraint;
    }

    public static Constraint createConstraint(String string, HttpConstraintElement httpConstraintElement) {
        return ConstraintSecurityHandler.createConstraint(string, httpConstraintElement.getRolesAllowed(), httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee());
    }

    public static Constraint createConstraint(String string, String[] stringArray, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, ServletSecurity.TransportGuarantee transportGuarantee) {
        Constraint constraint = ConstraintSecurityHandler.createConstraint();
        if (stringArray == null || stringArray.length == 0) {
            if (emptyRoleSemantic.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                constraint.setName(string + "-Deny");
                constraint.setAuthenticate(true);
            } else {
                constraint.setName(string + "-Permit");
                constraint.setAuthenticate(false);
            }
        } else {
            constraint.setAuthenticate(true);
            constraint.setRoles(stringArray);
            constraint.setName(string + "-RolesAllowed");
        }
        constraint.setDataConstraint(transportGuarantee.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL) ? 2 : 0);
        return constraint;
    }

    public static List<ConstraintMapping> getConstraintMappingsForPath(String string, List<ConstraintMapping> list) {
        if (string == null || "".equals(string.trim()) || list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintMapping> arrayList = new ArrayList<ConstraintMapping>();
        for (ConstraintMapping constraintMapping : list) {
            if (!string.equals(constraintMapping.getPathSpec())) continue;
            arrayList.add(constraintMapping);
        }
        return arrayList;
    }

    public static List<ConstraintMapping> removeConstraintMappingsForPath(String string, List<ConstraintMapping> list) {
        if (string == null || "".equals(string.trim()) || list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintMapping> arrayList = new ArrayList<ConstraintMapping>();
        for (ConstraintMapping constraintMapping : list) {
            if (string.equals(constraintMapping.getPathSpec())) continue;
            arrayList.add(constraintMapping);
        }
        return arrayList;
    }

    public static List<ConstraintMapping> createConstraintsWithMappingsForPath(String string, String string2, ServletSecurityElement servletSecurityElement) {
        ArrayList<ConstraintMapping> arrayList = new ArrayList<ConstraintMapping>();
        Constraint constraint = null;
        ConstraintMapping constraintMapping = null;
        if (servletSecurityElement.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT || servletSecurityElement.getRolesAllowed().length != 0 || servletSecurityElement.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            constraint = ConstraintSecurityHandler.createConstraint(string, (HttpConstraintElement)servletSecurityElement);
            constraintMapping = new ConstraintMapping();
            constraintMapping.setPathSpec(string2);
            constraintMapping.setConstraint(constraint);
            arrayList.add(constraintMapping);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Collection collection = servletSecurityElement.getHttpMethodConstraints();
        if (collection != null) {
            for (HttpMethodConstraintElement httpMethodConstraintElement : collection) {
                Constraint constraint2 = ConstraintSecurityHandler.createConstraint(string, (HttpConstraintElement)httpMethodConstraintElement);
                ConstraintMapping constraintMapping2 = new ConstraintMapping();
                constraintMapping2.setConstraint(constraint2);
                constraintMapping2.setPathSpec(string2);
                if (httpMethodConstraintElement.getMethodName() != null) {
                    constraintMapping2.setMethod(httpMethodConstraintElement.getMethodName());
                    arrayList2.add(httpMethodConstraintElement.getMethodName());
                }
                arrayList.add(constraintMapping2);
            }
        }
        if (arrayList2.size() > 0 && constraintMapping != null) {
            constraintMapping.setMethodOmissions(arrayList2.toArray(new String[arrayList2.size()]));
        }
        return arrayList;
    }

    @Override
    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getRoles() {
        return this._roles;
    }

    public void setConstraintMappings(List<ConstraintMapping> list) {
        this.setConstraintMappings(list, null);
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappingArray) {
        this.setConstraintMappings(Arrays.asList(constraintMappingArray), null);
    }

    @Override
    public void setConstraintMappings(List<ConstraintMapping> list, Set<String> set) {
        this._constraintMappings.clear();
        this._constraintMappings.addAll(list);
        if (set == null) {
            set = new HashSet<String>();
            for (ConstraintMapping constraintMapping : list) {
                String[] stringArray = constraintMapping.getConstraint().getRoles();
                if (stringArray == null) continue;
                for (String string : stringArray) {
                    if (ALL_METHODS.equals(string)) continue;
                    set.add(string);
                }
            }
        }
        this.setRoles(set);
        if (this.isStarted()) {
            for (ConstraintMapping constraintMapping : this._constraintMappings) {
                this.processConstraintMapping(constraintMapping);
            }
        }
    }

    public void setRoles(Set<String> set) {
        this._roles.clear();
        this._roles.addAll(set);
    }

    @Override
    public void addConstraintMapping(ConstraintMapping constraintMapping) {
        this._constraintMappings.add(constraintMapping);
        if (constraintMapping.getConstraint() != null && constraintMapping.getConstraint().getRoles() != null) {
            for (String string : constraintMapping.getConstraint().getRoles()) {
                if (ALL_METHODS.equals(string) || "**".equals(string)) continue;
                this.addRole(string);
            }
        }
        if (this.isStarted()) {
            this.processConstraintMapping(constraintMapping);
        }
    }

    @Override
    public void addRole(String string) {
        boolean bl = this._roles.add(string);
        if (this.isStarted() && bl) {
            for (Map map : this._constraintMap.values()) {
                for (RoleInfo roleInfo : map.values()) {
                    if (!roleInfo.isAnyRole()) continue;
                    roleInfo.addRole(string);
                }
            }
        }
    }

    @Override
    protected void doStart() {
        this._constraintMap.clear();
        if (this._constraintMappings != null) {
            for (ConstraintMapping constraintMapping : this._constraintMappings) {
                this.processConstraintMapping(constraintMapping);
            }
        }
        this.checkPathsWithUncoveredHttpMethods();
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this._constraintMap.clear();
    }

    protected void processConstraintMapping(ConstraintMapping constraintMapping) {
        RoleInfo roleInfo;
        RoleInfo roleInfo2;
        HashMap<String, RoleInfo> hashMap = (HashMap<String, RoleInfo>)this._constraintMap.get((Object)constraintMapping.getPathSpec());
        if (hashMap == null) {
            hashMap = new HashMap<String, RoleInfo>();
            this._constraintMap.put(constraintMapping.getPathSpec(), hashMap);
        }
        if ((roleInfo2 = (RoleInfo)hashMap.get(ALL_METHODS)) != null && roleInfo2.isForbidden()) {
            return;
        }
        if (constraintMapping.getMethodOmissions() != null && constraintMapping.getMethodOmissions().length > 0) {
            this.processConstraintMappingWithMethodOmissions(constraintMapping, hashMap);
            return;
        }
        String string = constraintMapping.getMethod();
        if (string == null) {
            string = ALL_METHODS;
        }
        if ((roleInfo = (RoleInfo)hashMap.get(string)) == null) {
            roleInfo = new RoleInfo();
            hashMap.put(string, roleInfo);
            if (roleInfo2 != null) {
                roleInfo.combine(roleInfo2);
            }
        }
        if (roleInfo.isForbidden()) {
            return;
        }
        this.configureRoleInfo(roleInfo, constraintMapping);
        if (roleInfo.isForbidden() && string.equals(ALL_METHODS)) {
            hashMap.clear();
            hashMap.put(ALL_METHODS, roleInfo);
        }
    }

    protected void processConstraintMappingWithMethodOmissions(ConstraintMapping constraintMapping, Map<String, RoleInfo> map) {
        String[] stringArray = constraintMapping.getMethodOmissions();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append(OMISSION_SUFFIX);
        RoleInfo roleInfo = new RoleInfo();
        map.put(stringBuilder.toString(), roleInfo);
        this.configureRoleInfo(roleInfo, constraintMapping);
    }

    protected void configureRoleInfo(RoleInfo roleInfo, ConstraintMapping constraintMapping) {
        Constraint constraint = constraintMapping.getConstraint();
        boolean bl = constraint.isForbidden();
        roleInfo.setForbidden(bl);
        UserDataConstraint userDataConstraint = UserDataConstraint.get(constraintMapping.getConstraint().getDataConstraint());
        roleInfo.setUserDataConstraint(userDataConstraint);
        if (!roleInfo.isForbidden()) {
            boolean bl2 = constraintMapping.getConstraint().getAuthenticate();
            roleInfo.setChecked(bl2);
            if (roleInfo.isChecked()) {
                if (constraintMapping.getConstraint().isAnyRole()) {
                    for (String string : this._roles) {
                        roleInfo.addRole(string);
                    }
                    roleInfo.setAnyRole(true);
                } else if (constraintMapping.getConstraint().isAnyAuth()) {
                    roleInfo.setAnyAuth(true);
                } else {
                    String[] stringArray;
                    for (String string : stringArray = constraintMapping.getConstraint().getRoles()) {
                        if (!this._roles.contains(string)) {
                            throw new IllegalArgumentException("Attempt to use undeclared role: " + string + ", known roles: " + this._roles);
                        }
                        roleInfo.addRole(string);
                    }
                }
            }
        }
    }

    @Override
    protected RoleInfo prepareConstraintInfo(String string, Request request) {
        Map map = (Map)this._constraintMap.match(string);
        if (map != null) {
            String string2 = request.getMethod();
            RoleInfo roleInfo = (RoleInfo)map.get(string2);
            if (roleInfo == null) {
                ArrayList<RoleInfo> arrayList = new ArrayList<RoleInfo>();
                RoleInfo roleInfo2 = (RoleInfo)map.get(ALL_METHODS);
                if (roleInfo2 != null) {
                    arrayList.add(roleInfo2);
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null || !((String)entry.getKey()).endsWith(OMISSION_SUFFIX) || ((String)entry.getKey()).contains(string2)) continue;
                    arrayList.add((RoleInfo)entry.getValue());
                }
                if (arrayList.size() == 0 && this.isDenyUncoveredHttpMethods()) {
                    roleInfo = new RoleInfo();
                    roleInfo.setForbidden(true);
                } else if (arrayList.size() == 1) {
                    roleInfo = (RoleInfo)arrayList.get(0);
                } else {
                    roleInfo = new RoleInfo();
                    roleInfo.setUserDataConstraint(UserDataConstraint.None);
                    for (RoleInfo roleInfo3 : arrayList) {
                        roleInfo.combine(roleInfo3);
                    }
                }
            }
            return roleInfo;
        }
        return null;
    }

    @Override
    protected boolean checkUserDataPermissions(String string, Request request, Response response, RoleInfo roleInfo) {
        if (roleInfo == null) {
            return true;
        }
        if (roleInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint userDataConstraint = roleInfo.getUserDataConstraint();
        if (userDataConstraint == null || userDataConstraint == UserDataConstraint.None) {
            return true;
        }
        HttpConfiguration httpConfiguration = Request.getBaseRequest((ServletRequest)request).getHttpChannel().getHttpConfiguration();
        if (userDataConstraint == UserDataConstraint.Confidential || userDataConstraint == UserDataConstraint.Integral) {
            if (request.isSecure()) {
                return true;
            }
            if (httpConfiguration.getSecurePort() > 0) {
                String string2 = httpConfiguration.getSecureScheme();
                int n = httpConfiguration.getSecurePort();
                String string3 = URIUtil.newURI((String)string2, (String)request.getServerName(), (int)n, (String)request.getRequestURI(), (String)request.getQueryString());
                response.setContentLength(0);
                response.sendRedirect(string3);
            } else {
                response.sendError(403, "!Secure");
            }
            request.setHandled(true);
            return false;
        }
        throw new IllegalArgumentException("Invalid dataConstraint value: " + (Object)((Object)userDataConstraint));
    }

    @Override
    protected boolean isAuthMandatory(Request request, Response response, Object object) {
        return object != null && ((RoleInfo)object).isChecked();
    }

    @Override
    protected boolean checkWebResourcePermissions(String string, Request request, Response response, Object object, UserIdentity userIdentity) {
        if (object == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)object;
        if (!roleInfo.isChecked()) {
            return true;
        }
        if (roleInfo.isAnyAuth() && request.getUserPrincipal() != null) {
            return true;
        }
        boolean bl = false;
        for (String string2 : roleInfo.getRoles()) {
            if (!userIdentity.isUserInRole(string2, null)) continue;
            bl = true;
            break;
        }
        if (roleInfo.isAnyRole() && request.getUserPrincipal() != null && bl) {
            return true;
        }
        return bl;
    }

    public void dump(Appendable appendable, String string) {
        this.dumpBeans(appendable, string, new Collection[]{Collections.singleton(this.getLoginService()), Collections.singleton(this.getIdentityService()), Collections.singleton(this.getAuthenticator()), Collections.singleton(this._roles), this._constraintMap.entrySet()});
    }

    @Override
    public void setDenyUncoveredHttpMethods(boolean bl) {
        this._denyUncoveredMethods = bl;
    }

    @Override
    public boolean isDenyUncoveredHttpMethods() {
        return this._denyUncoveredMethods;
    }

    @Override
    public boolean checkPathsWithUncoveredHttpMethods() {
        Set<String> set = this.getPathsWithUncoveredHttpMethods();
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                LOG.warn("{} has uncovered http methods for path: {}", new Object[]{ContextHandler.getCurrentContext(), string});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(new Throwable());
            }
            return true;
        }
        return false;
    }

    public Set<String> getPathsWithUncoveredHttpMethods() {
        if (this._denyUncoveredMethods) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this._constraintMap.keySet()) {
            Map map = (Map)this._constraintMap.get((Object)string);
            if (map.get(ALL_METHODS) != null) continue;
            boolean bl = this.omissionsExist(string, map);
            for (String string2 : map.keySet()) {
                if (string2.endsWith(OMISSION_SUFFIX)) {
                    Set<String> set = this.getOmittedMethods(string2);
                    for (String string3 : set) {
                        if (map.containsKey(string3)) continue;
                        hashSet.add(string);
                    }
                    continue;
                }
                if (bl) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected boolean omissionsExist(String string, Map<String, RoleInfo> map) {
        if (map == null) {
            return false;
        }
        boolean bl = false;
        for (String string2 : map.keySet()) {
            if (!string2.endsWith(OMISSION_SUFFIX)) continue;
            bl = true;
        }
        return bl;
    }

    protected Set<String> getOmittedMethods(String string) {
        if (string == null || !string.endsWith(OMISSION_SUFFIX)) {
            return Collections.emptySet();
        }
        String[] stringArray = string.split("\\.");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }
}

