/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.Serializable;
import java.util.Set;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public abstract class AbstractUserAuthentication
implements Serializable,
Authentication.User {
    private static final long serialVersionUID = -6290411814232723403L;
    protected String _method;
    protected transient UserIdentity _userIdentity;

    public AbstractUserAuthentication(String string, UserIdentity userIdentity) {
        this._method = string;
        this._userIdentity = userIdentity;
    }

    public String getAuthMethod() {
        return this._method;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public boolean isUserInRole(UserIdentity.Scope scope, String string) {
        String string2 = null;
        if (scope != null && scope.getRoleRefMap() != null) {
            string2 = (String)scope.getRoleRefMap().get(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        if ("**".equals(string2.trim())) {
            if (!this.declaredRolesContains("**")) {
                return true;
            }
            return this._userIdentity.isUserInRole(string, scope);
        }
        return this._userIdentity.isUserInRole(string, scope);
    }

    public boolean declaredRolesContains(String string) {
        SecurityHandler securityHandler = SecurityHandler.getCurrentSecurityHandler();
        if (securityHandler == null) {
            return false;
        }
        if (securityHandler instanceof ConstraintAware) {
            Set<String> set = ((ConstraintAware)((Object)securityHandler)).getRoles();
            return set != null && set.contains(string);
        }
        return false;
    }
}

