/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Link;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public class PlusDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = Log.getLogger(PlusDescriptorProcessor.class);

    public PlusDescriptorProcessor() {
        try {
            this.registerVisitor("env-entry", ((Object)((Object)this)).getClass().getMethod("visitEnvEntry", __signature));
            this.registerVisitor("resource-ref", ((Object)((Object)this)).getClass().getMethod("visitResourceRef", __signature));
            this.registerVisitor("resource-env-ref", ((Object)((Object)this)).getClass().getMethod("visitResourceEnvRef", __signature));
            this.registerVisitor("message-destination-ref", ((Object)((Object)this)).getClass().getMethod("visitMessageDestinationRef", __signature));
            this.registerVisitor("post-construct", ((Object)((Object)this)).getClass().getMethod("visitPostConstruct", __signature));
            this.registerVisitor("pre-destroy", ((Object)((Object)this)).getClass().getMethod("visitPreDestroy", __signature));
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public void start(WebAppContext webAppContext, Descriptor descriptor) {
        RunAsCollection runAsCollection;
        LifeCycleCallbackCollection lifeCycleCallbackCollection;
        InjectionCollection injectionCollection = (InjectionCollection)webAppContext.getAttribute("org.eclipse.jetty.injectionCollection");
        if (injectionCollection == null) {
            injectionCollection = new InjectionCollection();
            webAppContext.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injectionCollection);
        }
        if ((lifeCycleCallbackCollection = (LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) == null) {
            lifeCycleCallbackCollection = new LifeCycleCallbackCollection();
            webAppContext.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", (Object)lifeCycleCallbackCollection);
        }
        if ((runAsCollection = (RunAsCollection)webAppContext.getAttribute("org.eclipse.jetty.runAsCollection")) == null) {
            runAsCollection = new RunAsCollection();
            webAppContext.setAttribute("org.eclipse.jetty.runAsCollection", (Object)runAsCollection);
        }
    }

    public void end(WebAppContext webAppContext, Descriptor descriptor) {
    }

    public void visitEnvEntry(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("env-entry-name", false, true);
        String string2 = node.getString("env-entry-type", false, true);
        String string3 = node.getString("env-entry-value", false, true);
        if (string3 == null || string3.equals("")) {
            LOG.warn("No value for env-entry-name " + string, new Object[0]);
            return;
        }
        Origin origin = webAppContext.getMetaData().getOrigin("env-entry." + string);
        switch (origin) {
            case NotSet: {
                webAppContext.getMetaData().setOrigin("env-entry." + string, descriptor);
                this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                Object object = TypeUtil.valueOf((String)string2, (String)string3);
                this.bindEnvEntry(string, object);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    webAppContext.getMetaData().setOrigin("env-entry." + string, descriptor);
                    this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                    Object object = TypeUtil.valueOf((String)string2, (String)string3);
                    this.bindEnvEntry(string, object);
                    break;
                }
                Descriptor descriptor2 = webAppContext.getMetaData().getOriginDescriptor("env-entry." + string + ".injection");
                if (descriptor2 != null && !(descriptor2 instanceof FragmentDescriptor)) break;
                this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting env-entry " + string + " in " + descriptor.getResource());
            }
        }
    }

    public void visitResourceRef(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("res-ref-name", false, true);
        String string2 = node.getString("res-type", false, true);
        String string3 = node.getString("res-auth", false, true);
        String string4 = node.getString("res-sharing-scope", false, true);
        Origin origin = webAppContext.getMetaData().getOrigin("resource-ref." + string);
        switch (origin) {
            case NotSet: {
                webAppContext.getMetaData().setOrigin("resource-ref." + string, descriptor);
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, clazz);
                this.bindResourceRef(webAppContext, string, clazz);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    webAppContext.getMetaData().setOrigin("resource-ref." + string, descriptor);
                    Class clazz = TypeUtil.fromName((String)string2);
                    if (clazz == null) {
                        clazz = webAppContext.loadClass(string2);
                    }
                    this.addInjections(webAppContext, descriptor, node, string, clazz);
                    this.bindResourceRef(webAppContext, string, clazz);
                    break;
                }
                Descriptor descriptor2 = webAppContext.getMetaData().getOriginDescriptor("resource-ref." + string + ".injection");
                if (descriptor2 != null && !(descriptor2 instanceof FragmentDescriptor)) break;
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                break;
            }
            case WebFragment: {
                Object object;
                Object object2;
                Descriptor descriptor3 = webAppContext.getMetaData().getOriginDescriptor("resource-ref." + string);
                XmlParser.Node node2 = descriptor3.getRoot();
                Iterator iterator = node2.iterator();
                Object object3 = null;
                while (iterator.hasNext() && object3 == null) {
                    object2 = iterator.next();
                    if (!(object2 instanceof XmlParser.Node) || !"resource-ref".equals((object = (XmlParser.Node)object2).getTag()) || !string.equals(object.getString("res-ref-name", false, true))) continue;
                    object3 = object;
                }
                if (object3 != null) {
                    object2 = object3.getString("res-type", false, true);
                    object = object3.getString("res-auth", false, true);
                    String string5 = object3.getString("res-sharing-scope", false, true);
                    string2 = string2 == null ? "" : string2;
                    object2 = object2 == null ? "" : object2;
                    string3 = string3 == null ? "" : string3;
                    object = object == null ? "" : object;
                    string4 = string4 == null ? "" : string4;
                    String string6 = string5 = string5 == null ? "" : string5;
                    if (!(string2.equals(object2) && string3.equals(object) && string4.equals(string5))) {
                        throw new IllegalStateException("Conflicting resource-ref " + string + " in " + descriptor.getResource());
                    }
                    this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                    break;
                }
                throw new IllegalStateException("resource-ref." + string + " not found in declaring descriptor " + descriptor3);
            }
        }
    }

    public void visitResourceEnvRef(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("resource-env-ref-name", false, true);
        String string2 = node.getString("resource-env-ref-type", false, true);
        Origin origin = webAppContext.getMetaData().getOrigin("resource-env-ref." + string);
        switch (origin) {
            case NotSet: {
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, clazz);
                this.bindResourceEnvRef(webAppContext, string, clazz);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    webAppContext.getMetaData().setOrigin("resource-env-ref." + string, descriptor);
                    Class clazz = TypeUtil.fromName((String)string2);
                    if (clazz == null) {
                        clazz = webAppContext.loadClass(string2);
                    }
                    this.addInjections(webAppContext, descriptor, node, string, clazz);
                    this.bindResourceEnvRef(webAppContext, string, clazz);
                    break;
                }
                Descriptor descriptor2 = webAppContext.getMetaData().getOriginDescriptor("resource-env-ref." + string + ".injection");
                if (descriptor2 != null && !(descriptor2 instanceof FragmentDescriptor)) break;
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, clazz);
                break;
            }
            case WebFragment: {
                Object object;
                Descriptor descriptor3 = webAppContext.getMetaData().getOriginDescriptor("resource-env-ref." + string);
                XmlParser.Node node2 = descriptor3.getRoot();
                Iterator iterator = node2.iterator();
                XmlParser.Node node3 = null;
                while (iterator.hasNext() && node3 == null) {
                    XmlParser.Node node4;
                    object = iterator.next();
                    if (!(object instanceof XmlParser.Node) || !"resource-env-ref".equals((node4 = (XmlParser.Node)object).getTag()) || !string.equals(node4.getString("resource-env-ref-name", false, true))) continue;
                    node3 = node4;
                }
                if (node3 != null) {
                    object = node3.getString("resource-env-ref-type", false, true);
                    string2 = string2 == null ? "" : string2;
                    String string3 = object = object == null ? "" : object;
                    if (!string2.equals(object)) {
                        throw new IllegalStateException("Conflicting resource-env-ref " + string + " in " + descriptor.getResource());
                    }
                    this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                    break;
                }
                throw new IllegalStateException("resource-env-ref." + string + " not found in declaring descriptor " + descriptor3);
            }
        }
    }

    public void visitMessageDestinationRef(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("message-destination-ref-name", false, true);
        String string2 = node.getString("message-destination-type", false, true);
        String string3 = node.getString("message-destination-usage", false, true);
        Origin origin = webAppContext.getMetaData().getOrigin("message-destination-ref." + string);
        switch (origin) {
            case NotSet: {
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, clazz);
                this.bindMessageDestinationRef(webAppContext, string, clazz);
                webAppContext.getMetaData().setOrigin("message-destination-ref." + string, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    Class clazz = TypeUtil.fromName((String)string2);
                    if (clazz == null) {
                        clazz = webAppContext.loadClass(string2);
                    }
                    this.addInjections(webAppContext, descriptor, node, string, clazz);
                    this.bindMessageDestinationRef(webAppContext, string, clazz);
                    webAppContext.getMetaData().setOrigin("message-destination-ref." + string, descriptor);
                    break;
                }
                Descriptor descriptor2 = webAppContext.getMetaData().getOriginDescriptor("message-destination-ref." + string + ".injection");
                if (descriptor2 != null && !(descriptor2 instanceof FragmentDescriptor)) break;
                Class clazz = TypeUtil.fromName((String)string2);
                if (clazz == null) {
                    clazz = webAppContext.loadClass(string2);
                }
                this.addInjections(webAppContext, descriptor, node, string, clazz);
                break;
            }
            case WebFragment: {
                Object object;
                Object object2;
                Descriptor descriptor3 = webAppContext.getMetaData().getOriginDescriptor("message-destination-ref." + string);
                XmlParser.Node node2 = descriptor3.getRoot();
                Iterator iterator = node2.iterator();
                Object object3 = null;
                while (iterator.hasNext() && object3 == null) {
                    object2 = iterator.next();
                    if (!(object2 instanceof XmlParser.Node) || !"message-destination-ref".equals((object = (XmlParser.Node)object2).getTag()) || !string.equals(object.getString("message-destination-ref-name", false, true))) continue;
                    object3 = object;
                }
                if (object3 != null) {
                    object2 = node.getString("message-destination-type", false, true);
                    object = node.getString("message-destination-usage", false, true);
                    string2 = string2 == null ? "" : string2;
                    String string4 = string3 = string3 == null ? "" : string3;
                    if (!string2.equals(object2) || !string3.equalsIgnoreCase((String)object)) {
                        throw new IllegalStateException("Conflicting message-destination-ref " + string + " in " + descriptor.getResource());
                    }
                    this.addInjections(webAppContext, descriptor, node, string, TypeUtil.fromName((String)string2));
                    break;
                }
                throw new IllegalStateException("message-destination-ref." + string + " not found in declaring descriptor " + descriptor3);
            }
        }
    }

    public void visitPostConstruct(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("lifecycle-callback-class", false, true);
        String string2 = node.getString("lifecycle-callback-method", false, true);
        if (string == null || string.equals("")) {
            LOG.warn("No lifecycle-callback-class specified", new Object[0]);
            return;
        }
        if (string2 == null || string2.equals("")) {
            LOG.warn("No lifecycle-callback-method specified for class " + string, new Object[0]);
            return;
        }
        Origin origin = webAppContext.getMetaData().getOrigin("post-construct");
        switch (origin) {
            case NotSet: {
                webAppContext.getMetaData().setOrigin("post-construct", descriptor);
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PostConstructCallback postConstructCallback = new PostConstructCallback();
                    postConstructCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(postConstructCallback);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load post-construct target class " + string, new Object[0]);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PostConstructCallback postConstructCallback = new PostConstructCallback();
                    postConstructCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(postConstructCallback);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load post-construct target class " + string, new Object[0]);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PostConstructCallback postConstructCallback = new PostConstructCallback();
                    postConstructCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(postConstructCallback);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load post-construct target class " + string, new Object[0]);
                }
            }
        }
    }

    public void visitPreDestroy(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node) {
        String string = node.getString("lifecycle-callback-class", false, true);
        String string2 = node.getString("lifecycle-callback-method", false, true);
        if (string == null || string.equals("")) {
            LOG.warn("No lifecycle-callback-class specified for pre-destroy", new Object[0]);
            return;
        }
        if (string2 == null || string2.equals("")) {
            LOG.warn("No lifecycle-callback-method specified for pre-destroy class " + string, new Object[0]);
            return;
        }
        Origin origin = webAppContext.getMetaData().getOrigin("pre-destroy");
        switch (origin) {
            case NotSet: {
                webAppContext.getMetaData().setOrigin("pre-destroy", descriptor);
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PreDestroyCallback preDestroyCallback = new PreDestroyCallback();
                    preDestroyCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(preDestroyCallback);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load pre-destory target class " + string, new Object[0]);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PreDestroyCallback preDestroyCallback = new PreDestroyCallback();
                    preDestroyCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(preDestroyCallback);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load pre-destory target class " + string, new Object[0]);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class clazz = webAppContext.loadClass(string);
                    PreDestroyCallback preDestroyCallback = new PreDestroyCallback();
                    preDestroyCallback.setTarget(clazz, string2);
                    ((LifeCycleCallbackCollection)webAppContext.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(preDestroyCallback);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("Couldn't load pre-destory target class " + string, new Object[0]);
                }
            }
        }
    }

    public void addInjections(WebAppContext webAppContext, Descriptor descriptor, XmlParser.Node node, String string, Class<?> clazz) {
        Iterator iterator = node.iterator("injection-target");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string2 = node2.getString("injection-target-class", false, true);
            String string3 = node2.getString("injection-target-name", false, true);
            if (string2 == null || string2.equals("")) {
                LOG.warn("No classname found in injection-target", new Object[0]);
                continue;
            }
            if (string3 == null || string3.equals("")) {
                LOG.warn("No field or method name in injection-target", new Object[0]);
                continue;
            }
            InjectionCollection injectionCollection = (InjectionCollection)webAppContext.getAttribute("org.eclipse.jetty.injectionCollection");
            if (injectionCollection == null) {
                injectionCollection = new InjectionCollection();
                webAppContext.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injectionCollection);
            }
            try {
                Class clazz2 = webAppContext.loadClass(string2);
                Injection injection = new Injection();
                injection.setJndiName(string);
                injection.setTarget(clazz2, string3, clazz);
                injectionCollection.add(injection);
                if (webAppContext.getMetaData().getOriginDescriptor(node.getTag() + "." + string + ".injection") != null) continue;
                webAppContext.getMetaData().setOrigin(node.getTag() + "." + string + ".injection", descriptor);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn("Couldn't load injection target class " + string2, new Object[0]);
            }
        }
    }

    public void bindEnvEntry(String string, Object object) {
        Object object2;
        InitialContext initialContext = null;
        boolean bl = false;
        initialContext = new InitialContext();
        try {
            object2 = (NamingEntry)initialContext.lookup("java:comp/env/" + NamingEntryUtil.makeNamingEntryName(initialContext.getNameParser(""), string));
            if (object2 != null && object2 instanceof EnvEntry) {
                EnvEntry envEntry = (EnvEntry)object2;
                bl = envEntry.isOverrideWebXml();
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        if (!bl) {
            object2 = (Context)initialContext.lookup("java:comp/env");
            NamingUtil.bind((Context)object2, (String)string, (Object)object);
        }
    }

    public void bindResourceRef(WebAppContext webAppContext, String string, Class<?> clazz) {
        this.bindEntry(webAppContext, string, clazz);
    }

    public void bindResourceEnvRef(WebAppContext webAppContext, String string, Class<?> clazz) {
        this.bindEntry(webAppContext, string, clazz);
    }

    public void bindMessageDestinationRef(WebAppContext webAppContext, String string, Class<?> clazz) {
        this.bindEntry(webAppContext, string, clazz);
    }

    protected void bindEntry(WebAppContext webAppContext, String string, Class<?> clazz) {
        String string2 = string;
        boolean bl = false;
        WebAppContext webAppContext2 = webAppContext;
        NamingEntry namingEntry = NamingEntryUtil.lookupNamingEntry(webAppContext2, string);
        if (namingEntry != null && namingEntry instanceof Link) {
            string2 = ((Link)namingEntry).getLink();
        }
        if (bl = NamingEntryUtil.bindToENC(webAppContext2 = webAppContext, string, string2)) {
            return;
        }
        webAppContext2 = webAppContext.getServer();
        bl = NamingEntryUtil.bindToENC(webAppContext2, string, string2);
        if (bl) {
            return;
        }
        bl = NamingEntryUtil.bindToENC(null, string, string2);
        if (bl) {
            return;
        }
        string2 = clazz.getName() + "/default";
        NamingEntry namingEntry2 = NamingEntryUtil.lookupNamingEntry(webAppContext.getServer(), string2);
        if (namingEntry2 == null) {
            namingEntry2 = NamingEntryUtil.lookupNamingEntry(null, string2);
        }
        if (namingEntry2 == null) {
            throw new IllegalStateException("Nothing to bind for name " + string);
        }
        namingEntry2.bindToENC(string);
    }
}

