/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class PlusDecorator
implements Decorator {
    private static final Logger LOG = Log.getLogger(PlusDecorator.class);
    protected WebAppContext _context;

    public PlusDecorator(WebAppContext webAppContext) {
        this._context = webAppContext;
    }

    public Object decorate(Object object) {
        LifeCycleCallbackCollection lifeCycleCallbackCollection;
        InjectionCollection injectionCollection;
        RunAsCollection runAsCollection = (RunAsCollection)this._context.getAttribute("org.eclipse.jetty.runAsCollection");
        if (runAsCollection != null) {
            runAsCollection.setRunAs(object);
        }
        if ((injectionCollection = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection")) != null) {
            injectionCollection.inject(object);
        }
        if ((lifeCycleCallbackCollection = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            try {
                lifeCycleCallbackCollection.callPostConstructCallback(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return object;
    }

    public void destroy(Object object) {
        LifeCycleCallbackCollection lifeCycleCallbackCollection = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        if (lifeCycleCallbackCollection != null) {
            try {
                lifeCycleCallbackCollection.callPreDestroyCallback(object);
            }
            catch (Exception exception) {
                LOG.warn("Destroying instance of " + object.getClass(), (Throwable)exception);
            }
        }
    }
}

