/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.PlusDecorator;
import org.eclipse.jetty.plus.webapp.PlusDescriptorProcessor;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    public void preConfigure(WebAppContext webAppContext) {
        webAppContext.getObjectFactory().addDecorator((Decorator)new PlusDecorator(webAppContext));
    }

    public void cloneConfigure(WebAppContext webAppContext, WebAppContext webAppContext2) {
        webAppContext2.getObjectFactory().addDecorator((Decorator)new PlusDecorator(webAppContext2));
    }

    public void configure(WebAppContext webAppContext) {
        this.bindUserTransaction(webAppContext);
        webAppContext.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext webAppContext) {
        this.lockCompEnv(webAppContext);
    }

    public void deconfigure(WebAppContext webAppContext) {
        this.unlockCompEnv(webAppContext);
        this._key = null;
        webAppContext.setAttribute("org.eclipse.jetty.injectionCollection", null);
        webAppContext.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext webAppContext) {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException nameNotFoundException) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext webAppContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
        try {
            Random random = new Random();
            this._key = new Integer(random.nextInt());
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp");
            context.addToEnvironment("org.eclipse.jetty.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext webAppContext) {
        if (this._key != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
            try {
                InitialContext initialContext = new InitialContext();
                Context context = (Context)initialContext.lookup("java:comp");
                context.addToEnvironment("org.eclipse.jetty.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

