/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class EnvConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";
    private URL jettyEnvXmlUrl;

    public void setJettyEnvXml(URL uRL) {
        this.jettyEnvXmlUrl = uRL;
    }

    public void preConfigure(WebAppContext webAppContext) {
        this.createEnvContext(webAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext webAppContext) {
        Object object;
        Resource resource;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp " + webAppContext.getContextPath(), new Object[0]);
        }
        if (this.jettyEnvXmlUrl == null && (resource = webAppContext.getWebInf()) != null && resource.isDirectory() && (object = resource.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = object.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            resource = localContextRoot.getRoot();
            synchronized (resource) {
                object = new ArrayList();
                NamingContext.Listener listener = new NamingContext.Listener((List)object){
                    final /* synthetic */ List val$bindings;
                    {
                        this.val$bindings = list;
                    }

                    public void unbind(NamingContext namingContext, Binding binding) {
                    }

                    public Binding bind(NamingContext namingContext, Binding binding) {
                        this.val$bindings.add(new Bound(namingContext, binding.getName()));
                        return binding;
                    }
                };
                try {
                    localContextRoot.getRoot().addListener(listener);
                    XmlConfiguration xmlConfiguration = new XmlConfiguration(this.jettyEnvXmlUrl);
                    xmlConfiguration.configure((Object)webAppContext);
                }
                finally {
                    localContextRoot.getRoot().removeListener(listener);
                    webAppContext.setAttribute(JETTY_ENV_BINDINGS, object);
                }
            }
        }
        this.bindEnvEntries(webAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconfigure(WebAppContext webAppContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)webAppContext.getClassLoader());
        try {
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp");
            context.destroySubcontext("env");
            List list = (List)webAppContext.getAttribute(JETTY_ENV_BINDINGS);
            webAppContext.setAttribute(JETTY_ENV_BINDINGS, null);
            if (list != null) {
                Collections.reverse(list);
                for (Bound bound : list) {
                    bound._context.destroySubcontext(bound._name);
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            LOG.warn((Throwable)nameNotFoundException);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void destroy(WebAppContext webAppContext) {
        try {
            NamingContext namingContext = (NamingContext)NamingEntryUtil.getContextForScope(webAppContext);
            namingContext.getParent().destroySubcontext(namingContext.getName());
        }
        catch (NameNotFoundException nameNotFoundException) {
            LOG.ignore((Throwable)nameNotFoundException);
            LOG.debug("No jndi entries scoped to webapp {}", new Object[]{webAppContext});
        }
        catch (NamingException namingException) {
            LOG.debug("Error unbinding jndi entries scoped to webapp " + webAppContext, (Throwable)namingException);
        }
    }

    public void bindEnvEntries(WebAppContext webAppContext) {
        Name name;
        LOG.debug("Binding env entries from the jvm scope", new Object[0]);
        InitialContext initialContext = new InitialContext();
        Context context = (Context)initialContext.lookup("java:comp/env");
        Server server = null;
        List<Object> list = NamingEntryUtil.lookupNamingEntries(server, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            name = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind((Context)context, (String)name.toString(), (Object)envEntry);
        }
        LOG.debug("Binding env entries from the server scope", new Object[0]);
        server = webAppContext.getServer();
        list = NamingEntryUtil.lookupNamingEntries(server, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            name = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind((Context)context, (String)name.toString(), (Object)envEntry);
        }
        LOG.debug("Binding env entries from the context scope", new Object[0]);
        server = webAppContext;
        list = NamingEntryUtil.lookupNamingEntries(server, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            name = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind((Context)context, (String)name.toString(), (Object)envEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext webAppContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)webAppContext.getClassLoader());
        try {
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp");
            context.createSubcontext("env");
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static class Bound {
        final NamingContext _context;
        final String _name;

        Bound(NamingContext namingContext, String string) {
            this._context = namingContext;
            this._name = string;
        }
    }
}

