/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.security;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.sql.DataSource;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class DataSourceLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(DataSourceLoginService.class);
    private String _jndiName = "javax.sql.DataSource/default";
    private DataSource _datasource;
    private Server _server;
    private String _userTableName = "users";
    private String _userTableKey = "id";
    private String _userTableUserField = "username";
    private String _userTablePasswordField = "pwd";
    private String _roleTableName = "roles";
    private String _roleTableKey = "id";
    private String _roleTableRoleField = "role";
    private String _userRoleTableName = "user_roles";
    private String _userRoleTableUserKey = "user_id";
    private String _userRoleTableRoleKey = "role_id";
    private int _cacheMs = 30000;
    private long _lastPurge = 0L;
    private String _userSql;
    private String _roleSql;
    private boolean _createTables = false;

    public DataSourceLoginService() {
    }

    public DataSourceLoginService(String string) {
        this.setName(string);
    }

    public DataSourceLoginService(String string, IdentityService identityService) {
        this.setName(string);
        this.setIdentityService(identityService);
    }

    public void setJndiName(String string) {
        this._jndiName = string;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void setCreateTables(boolean bl) {
        this._createTables = bl;
    }

    public boolean getCreateTables() {
        return this._createTables;
    }

    public void setUserTableName(String string) {
        this._userTableName = string;
    }

    public String getUserTableName() {
        return this._userTableName;
    }

    public String getUserTableKey() {
        return this._userTableKey;
    }

    public void setUserTableKey(String string) {
        this._userTableKey = string;
    }

    public String getUserTableUserField() {
        return this._userTableUserField;
    }

    public void setUserTableUserField(String string) {
        this._userTableUserField = string;
    }

    public String getUserTablePasswordField() {
        return this._userTablePasswordField;
    }

    public void setUserTablePasswordField(String string) {
        this._userTablePasswordField = string;
    }

    public String getRoleTableName() {
        return this._roleTableName;
    }

    public void setRoleTableName(String string) {
        this._roleTableName = string;
    }

    public String getRoleTableKey() {
        return this._roleTableKey;
    }

    public void setRoleTableKey(String string) {
        this._roleTableKey = string;
    }

    public String getRoleTableRoleField() {
        return this._roleTableRoleField;
    }

    public void setRoleTableRoleField(String string) {
        this._roleTableRoleField = string;
    }

    public String getUserRoleTableName() {
        return this._userRoleTableName;
    }

    public void setUserRoleTableName(String string) {
        this._userRoleTableName = string;
    }

    public String getUserRoleTableUserKey() {
        return this._userRoleTableUserKey;
    }

    public void setUserRoleTableUserKey(String string) {
        this._userRoleTableUserKey = string;
    }

    public String getUserRoleTableRoleKey() {
        return this._userRoleTableRoleKey;
    }

    public void setUserRoleTableRoleKey(String string) {
        this._userRoleTableRoleKey = string;
    }

    public void setCacheMs(int n) {
        this._cacheMs = n;
    }

    public int getCacheMs() {
        return this._cacheMs;
    }

    protected void loadUsers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected UserIdentity loadUser(String string) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._userSql);){
            preparedStatement.setObject(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                int n = resultSet.getInt(this._userTableKey);
                String string2 = resultSet.getString(this._userTablePasswordField);
                ArrayList<String> arrayList = new ArrayList<String>();
                try (PreparedStatement preparedStatement2 = connection.prepareStatement(this._roleSql);){
                    preparedStatement2.setInt(1, n);
                    try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                        while (resultSet2.next()) {
                            arrayList.add(resultSet2.getString(this._roleTableRoleField));
                        }
                    }
                }
                preparedStatement2 = this.putUser(string, Credential.getCredential((String)string2), arrayList.toArray(new String[arrayList.size()]));
                return preparedStatement2;
            }
        }
        catch (NamingException namingException) {
            LOG.warn("No datasource for " + this._jndiName, (Throwable)namingException);
            return null;
        }
        catch (SQLException sQLException) {
            LOG.warn("Problem loading user info for " + string, (Throwable)sQLException);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MappedLoginService.KnownUser loadUserInfo(String string) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._userSql);){
            preparedStatement.setObject(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                int n = resultSet.getInt(this._userTableKey);
                String string2 = resultSet.getString(this._userTablePasswordField);
                DBUser dBUser = new DBUser(string, Credential.getCredential((String)string2), n);
                return dBUser;
            }
        }
        catch (NamingException namingException) {
            LOG.warn("No datasource for " + this._jndiName, (Throwable)namingException);
            return null;
        }
        catch (SQLException sQLException) {
            LOG.warn("Problem loading user info for " + string, (Throwable)sQLException);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String[] loadRoleInfo(MappedLoginService.KnownUser var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        long l = System.currentTimeMillis();
        if (l - this._lastPurge > (long)this._cacheMs || this._cacheMs == 0) {
            this._users.clear();
            this._lastPurge = l;
        }
        return super.login(string, object, servletRequest);
    }

    public void initDb() {
        if (this._datasource != null) {
            return;
        }
        InitialContext initialContext = new InitialContext();
        assert (initialContext != null);
        if (this._server != null) {
            try {
                this._datasource = (DataSource)NamingEntryUtil.lookup(this._server, this._jndiName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (this._datasource == null) {
            this._datasource = (DataSource)NamingEntryUtil.lookup(null, this._jndiName);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTableName + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTableName + " r, " + this._userRoleTableName + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
        this.prepareTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareTables() {
        if (!this._createTables) {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("createTables false", new Object[0]);
            return;
        }
        boolean bl = true;
        Connection connection = this.getConnection();
        try (Statement statement = connection.createStatement();){
            block79: {
                Throwable throwable;
                ResultSet resultSet;
                String string;
                DatabaseMetaData databaseMetaData;
                block78: {
                    block77: {
                        bl = connection.getAutoCommit();
                        connection.setAutoCommit(false);
                        databaseMetaData = connection.getMetaData();
                        string = databaseMetaData.storesLowerCaseIdentifiers() ? this._userTableName.toLowerCase(Locale.ENGLISH) : (databaseMetaData.storesUpperCaseIdentifiers() ? this._userTableName.toUpperCase(Locale.ENGLISH) : this._userTableName);
                        resultSet = databaseMetaData.getTables(null, null, string, null);
                        throwable = null;
                        try {
                            if (resultSet.next()) break block77;
                            statement.executeUpdate("create table " + this._userTableName + "(" + this._userTableKey + " integer," + this._userTableUserField + " varchar(100) not null unique," + this._userTablePasswordField + " varchar(20) not null, primary key(" + this._userTableKey + "))");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Created table " + this._userTableName, new Object[0]);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resultSet != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                        }
                    }
                    string = databaseMetaData.storesLowerCaseIdentifiers() ? this._roleTableName.toLowerCase(Locale.ENGLISH) : (databaseMetaData.storesUpperCaseIdentifiers() ? this._roleTableName.toUpperCase(Locale.ENGLISH) : this._roleTableName);
                    resultSet = databaseMetaData.getTables(null, null, string, null);
                    throwable = null;
                    try {
                        if (resultSet.next()) break block78;
                        String string2 = "create table " + this._roleTableName + " (" + this._roleTableKey + " integer, " + this._roleTableRoleField + " varchar(100) not null unique, primary key(" + this._roleTableKey + "))";
                        statement.executeUpdate(string2);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Created table " + this._roleTableName, new Object[0]);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                string = databaseMetaData.storesLowerCaseIdentifiers() ? this._userRoleTableName.toLowerCase(Locale.ENGLISH) : (databaseMetaData.storesUpperCaseIdentifiers() ? this._userRoleTableName.toUpperCase(Locale.ENGLISH) : this._userRoleTableName);
                resultSet = databaseMetaData.getTables(null, null, string, null);
                throwable = null;
                try {
                    if (resultSet.next()) break block79;
                    statement.executeUpdate("create table " + this._userRoleTableName + " (" + this._userRoleTableUserKey + " integer, " + this._userRoleTableRoleKey + " integer, " + "primary key (" + this._userRoleTableUserKey + ", " + this._userRoleTableRoleKey + "))");
                    statement.executeUpdate("create index indx_user_role on " + this._userRoleTableName + "(" + this._userRoleTableUserKey + ")");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._userRoleTableName + " and index", new Object[0]);
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            connection.commit();
            return;
        }
        finally {
            try {
                connection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepare tables", (Throwable)sQLException);
                }
            }
            finally {
                block81: {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        if (!LOG.isDebugEnabled()) break block81;
                        LOG.debug("Prepare tables", (Throwable)sQLException);
                    }
                }
            }
        }
    }

    private Connection getConnection() {
        this.initDb();
        return this._datasource.getConnection();
    }

    public class DBUser
    extends MappedLoginService.KnownUser {
        private int _key;

        public DBUser(String string, Credential credential, int n) {
            super(string, credential);
            this._key = n;
        }

        public int getKey() {
            return this._key;
        }
    }
}

