/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Logger;

public class Transaction
extends NamingEntry {
    private static Logger __log = NamingUtil.__log;
    public static final String USER_TRANSACTION = "UserTransaction";

    public static void bindToENC() {
        Transaction transaction = (Transaction)NamingEntryUtil.lookupNamingEntry(null, USER_TRANSACTION);
        if (transaction == null) {
            throw new NameNotFoundException("UserTransaction not found");
        }
        transaction.bindToComp();
    }

    public Transaction(UserTransaction userTransaction) {
        super(USER_TRANSACTION);
        this.save(userTransaction);
    }

    @Override
    public void bindToENC(String string) {
        InitialContext initialContext = new InitialContext();
        Context context = (Context)initialContext.lookup("java:comp/env");
        __log.debug("Binding java:comp/env" + this.getJndiName() + " to " + this._objectNameString, new Object[0]);
        NamingUtil.bind((Context)context, (String)string, (Object)new LinkRef(this._objectNameString));
    }

    private void bindToComp() {
        InitialContext initialContext = new InitialContext();
        Context context = (Context)initialContext.lookup("java:comp");
        __log.debug("Binding java:comp/" + this.getJndiName() + " to " + this._objectNameString, new Object[0]);
        NamingUtil.bind((Context)context, (String)this.getJndiName(), (Object)new LinkRef(this._objectNameString));
    }

    @Override
    public void unbindENC() {
        try {
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp");
            __log.debug("Unbinding java:comp/" + this.getJndiName(), new Object[0]);
            context.unbind(this.getJndiName());
        }
        catch (NamingException namingException) {
            __log.warn((Throwable)namingException);
        }
    }
}

