/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.util.log.Logger;

public class NamingEntryUtil {
    private static Logger __log = NamingUtil.__log;

    public static boolean bindToENC(Object object, String string, String string2) {
        NamingEntry namingEntry;
        if (string == null || string.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (string2 == null || "".equals(string2)) {
            string2 = string;
        }
        if ((namingEntry = NamingEntryUtil.lookupNamingEntry(object, string2)) == null) {
            return false;
        }
        namingEntry.bindToENC(string);
        return true;
    }

    public static NamingEntry lookupNamingEntry(Object object, String string) {
        NamingEntry namingEntry = null;
        try {
            Name name = NamingEntryUtil.getNameForScope(object);
            InitialContext initialContext = new InitialContext();
            NameParser nameParser = initialContext.getNameParser("");
            Name name2 = NamingEntryUtil.makeNamingEntryName(nameParser, string);
            name.addAll(name2);
            namingEntry = (NamingEntry)initialContext.lookup(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return namingEntry;
    }

    public static Object lookup(Object object, String string) {
        Name name = NamingEntryUtil.getNameForScope(object);
        InitialContext initialContext = new InitialContext();
        NameParser nameParser = initialContext.getNameParser("");
        name.addAll(nameParser.parse(string));
        return initialContext.lookup(name);
    }

    public static List<Object> lookupNamingEntries(Object object, Class<?> clazz) {
        try {
            Context context = NamingEntryUtil.getContextForScope(object);
            Context context2 = (Context)context.lookup("__");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            NamingEntryUtil.lookupNamingEntries(arrayList, context2, clazz);
            return arrayList;
        }
        catch (NameNotFoundException nameNotFoundException) {
            return Collections.emptyList();
        }
    }

    public static Name makeNamingEntryName(NameParser nameParser, NamingEntry namingEntry) {
        return NamingEntryUtil.makeNamingEntryName(nameParser, namingEntry == null ? null : namingEntry.getJndiName());
    }

    public static Name makeNamingEntryName(NameParser nameParser, String string) {
        Object object;
        if (string == null) {
            return null;
        }
        if (nameParser == null) {
            object = new InitialContext();
            nameParser = ((InitialContext)object).getNameParser("");
        }
        object = nameParser.parse("");
        object.add("__");
        object.addAll(nameParser.parse(string));
        return object;
    }

    public static Name getNameForScope(Object object) {
        try {
            InitialContext initialContext = new InitialContext();
            NameParser nameParser = initialContext.getNameParser("");
            Name name = nameParser.parse("");
            if (object != null) {
                name.add(NamingEntryUtil.canonicalizeScope(object));
            }
            return name;
        }
        catch (NamingException namingException) {
            __log.warn((Throwable)namingException);
            return null;
        }
    }

    public static Context getContextForScope(Object object) {
        InitialContext initialContext = new InitialContext();
        NameParser nameParser = initialContext.getNameParser("");
        Name name = nameParser.parse("");
        if (object != null) {
            name.add(NamingEntryUtil.canonicalizeScope(object));
        }
        return (Context)initialContext.lookup(name);
    }

    public static Context getContextForNamingEntries(Object object) {
        Context context = NamingEntryUtil.getContextForScope(object);
        return (Context)context.lookup("__");
    }

    private static List<Object> lookupNamingEntries(List<Object> list, Context context, Class<?> clazz) {
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = namingEnumeration.next();
                if (binding.getObject() instanceof Context) {
                    NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                    continue;
                }
                if (!clazz.isInstance(binding.getObject())) continue;
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            __log.debug("No entries of type " + clazz.getName() + " in context=" + context, new Object[0]);
        }
        return list;
    }

    private static String canonicalizeScope(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.getClass().getName() + "@" + Long.toHexString(object.hashCode());
        string = string.replace('/', '_').replace(' ', '_');
        return string;
    }
}

