/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Logger;

public abstract class NamingEntry {
    private static Logger __log = NamingUtil.__log;
    public static final String __contextName = "__";
    protected final Object _scope;
    protected final String _jndiName;
    protected String _namingEntryNameString;
    protected String _objectNameString;

    public String toString() {
        return this._jndiName;
    }

    protected NamingEntry(Object object, String string) {
        this._scope = object;
        this._jndiName = string;
    }

    protected NamingEntry(String string) {
        this(null, string);
    }

    public void bindToENC(String string) {
        InitialContext initialContext = new InitialContext();
        Context context = (Context)initialContext.lookup("java:comp/env");
        __log.debug("Binding java:comp/env/" + string + " to " + this._objectNameString, new Object[0]);
        NamingUtil.bind((Context)context, (String)string, (Object)new LinkRef(this._objectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp/env");
            __log.debug("Unbinding java:comp/env/" + this.getJndiName(), new Object[0]);
            context.unbind(this.getJndiName());
        }
        catch (NamingException namingException) {
            __log.warn((Throwable)namingException);
        }
    }

    public void release() {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.unbind(this._objectNameString);
            initialContext.unbind(this._namingEntryNameString);
            this._namingEntryNameString = null;
            this._objectNameString = null;
        }
        catch (NamingException namingException) {
            __log.warn((Throwable)namingException);
        }
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getJndiNameInScope() {
        return this._objectNameString;
    }

    protected void save(Object object) {
        __log.debug("SAVE {} in {}", new Object[]{this, this._scope});
        InitialContext initialContext = new InitialContext();
        NameParser nameParser = initialContext.getNameParser("");
        Name name = NamingEntryUtil.getNameForScope(this._scope);
        Name name2 = NamingEntryUtil.makeNamingEntryName(nameParser, this.getJndiName());
        name2.addAll(0, name);
        this._namingEntryNameString = name2.toString();
        NamingUtil.bind((Context)initialContext, (String)this._namingEntryNameString, (Object)this);
        Name name3 = nameParser.parse(this.getJndiName());
        name3.addAll(0, name);
        this._objectNameString = name3.toString();
        NamingUtil.bind((Context)initialContext, (String)this._objectNameString, (Object)object);
    }
}

