/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LifeCycleCallbackCollection {
    private static final Logger LOG = Log.getLogger(LifeCycleCallbackCollection.class);
    public static final String LIFECYCLE_CALLBACK_COLLECTION = "org.eclipse.jetty.lifecyleCallbackCollection";
    private HashMap<String, List<LifeCycleCallback>> postConstructCallbacksMap = new HashMap();
    private HashMap<String, List<LifeCycleCallback>> preDestroyCallbacksMap = new HashMap();

    public void add(LifeCycleCallback lifeCycleCallback) {
        if (lifeCycleCallback == null || lifeCycleCallback.getTargetClassName() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding callback for class=" + lifeCycleCallback.getTargetClass() + " on " + lifeCycleCallback.getTarget(), new Object[0]);
        }
        HashMap<String, List<LifeCycleCallback>> hashMap = null;
        if (lifeCycleCallback instanceof PreDestroyCallback) {
            hashMap = this.preDestroyCallbacksMap;
        }
        if (lifeCycleCallback instanceof PostConstructCallback) {
            hashMap = this.postConstructCallbacksMap;
        }
        if (hashMap == null) {
            throw new IllegalArgumentException("Unsupported lifecycle callback type: " + lifeCycleCallback);
        }
        ArrayList<LifeCycleCallback> arrayList = (ArrayList<LifeCycleCallback>)hashMap.get(lifeCycleCallback.getTargetClassName());
        if (arrayList == null) {
            arrayList = new ArrayList<LifeCycleCallback>();
            hashMap.put(lifeCycleCallback.getTargetClassName(), arrayList);
        }
        if (!arrayList.contains(lifeCycleCallback)) {
            arrayList.add(lifeCycleCallback);
        }
    }

    public List<LifeCycleCallback> getPreDestroyCallbacks(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return this.preDestroyCallbacksMap.get(clazz.getName());
    }

    public List<LifeCycleCallback> getPostConstructCallbacks(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return this.postConstructCallbacksMap.get(clazz.getName());
    }

    public void callPostConstructCallback(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        List<LifeCycleCallback> list = this.postConstructCallbacksMap.get(clazz.getName());
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).callback(object);
        }
    }

    public void callPreDestroyCallback(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        List<LifeCycleCallback> list = this.preDestroyCallbacksMap.get(clazz.getName());
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).callback(object);
        }
    }

    public Map<String, List<LifeCycleCallback>> getPostConstructCallbackMap() {
        return Collections.unmodifiableMap(this.postConstructCallbacksMap);
    }

    public Map<String, List<LifeCycleCallback>> getPreDestroyCallbackMap() {
        return Collections.unmodifiableMap(this.preDestroyCallbacksMap);
    }

    public Collection<LifeCycleCallback> getPostConstructCallbacks() {
        ArrayList arrayList = new ArrayList();
        for (String string : this.postConstructCallbacksMap.keySet()) {
            arrayList.addAll(this.postConstructCallbacksMap.get(string));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection<LifeCycleCallback> getPreDestroyCallbacks() {
        ArrayList arrayList = new ArrayList();
        for (String string : this.preDestroyCallbacksMap.keySet()) {
            arrayList.addAll(this.preDestroyCallbacksMap.get(string));
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

