/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.util.IntrospectionUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;

public abstract class LifeCycleCallback {
    public static final Object[] __EMPTY_ARGS = new Object[0];
    private Method _target;
    private Class<?> _targetClass;
    private String _className;
    private String _methodName;

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public String getTargetClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Method getTarget() {
        return this._target;
    }

    public void setTarget(String string, String string2) {
        this._className = string;
        this._methodName = string2;
    }

    public void setTarget(Class<?> clazz, String string) {
        try {
            Method method = IntrospectionUtil.findMethod(clazz, (String)string, null, (boolean)true, (boolean)true);
            this.validate(clazz, method);
            this._target = method;
            this._targetClass = clazz;
            this._className = clazz.getCanonicalName();
            this._methodName = string;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Method " + string + " not found on class " + clazz.getName());
        }
    }

    public void callback(Object object) {
        if (this._target == null) {
            if (this._targetClass == null) {
                this._targetClass = Loader.loadClass(null, (String)this._className);
            }
            this._target = this._targetClass.getDeclaredMethod(this._methodName, TypeUtil.NO_ARGS);
        }
        if (this._target != null) {
            boolean bl = this.getTarget().isAccessible();
            this.getTarget().setAccessible(true);
            this.getTarget().invoke(object, __EMPTY_ARGS);
            this.getTarget().setAccessible(bl);
        }
    }

    public Method findMethod(Package package_, Class<?> clazz, String string, boolean bl) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, new Class[0]);
            if (bl) {
                int n = method.getModifiers();
                if (Modifier.isProtected(n) || Modifier.isPublic(n) || !Modifier.isPrivate(n) && package_.equals(clazz.getPackage())) {
                    return method;
                }
                return this.findMethod(clazz.getPackage(), clazz.getSuperclass(), string, true);
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.findMethod(clazz.getPackage(), clazz.getSuperclass(), string, true);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LifeCycleCallback)) {
            return false;
        }
        LifeCycleCallback lifeCycleCallback = (LifeCycleCallback)object;
        if (lifeCycleCallback.getTargetClass() == null ? this.getTargetClass() != null : !lifeCycleCallback.getTargetClass().equals(this.getTargetClass())) {
            return false;
        }
        return !(lifeCycleCallback.getTarget() == null ? this.getTarget() != null : !lifeCycleCallback.getTarget().equals(this.getTarget()));
    }

    public abstract void validate(Class<?> var1, Method var2);
}

