/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InjectionCollection {
    private static final Logger LOG = Log.getLogger(InjectionCollection.class);
    public static final String INJECTION_COLLECTION = "org.eclipse.jetty.injectionCollection";
    private HashMap<String, List<Injection>> _injectionMap = new HashMap();

    public void add(Injection injection) {
        List<Injection> list;
        if (injection == null || injection.getTargetClass() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding injection for class=" + injection.getTargetClass() + " on a " + injection.getTarget().getName(), new Object[0]);
        }
        if ((list = this._injectionMap.get(injection.getTargetClass().getCanonicalName())) == null) {
            list = new ArrayList<Injection>();
            this._injectionMap.put(injection.getTargetClass().getCanonicalName(), list);
        }
        list.add(injection);
    }

    public List<Injection> getInjections(String string) {
        if (string == null) {
            return null;
        }
        return this._injectionMap.get(string);
    }

    public Injection getInjection(String string, Class<?> clazz, Field field) {
        if (field == null || clazz == null) {
            return null;
        }
        List<Injection> list = this.getInjections(clazz.getCanonicalName());
        if (list == null) {
            return null;
        }
        Iterator<Injection> iterator = list.iterator();
        Injection injection = null;
        while (iterator.hasNext() && injection == null) {
            Injection injection2 = iterator.next();
            if (!injection2.isField() || !field.getName().equals(injection2.getTarget().getName())) continue;
            injection = injection2;
        }
        return injection;
    }

    public Injection getInjection(String string, Class<?> clazz, Method method, Class<?> clazz2) {
        if (clazz == null || method == null || clazz2 == null) {
            return null;
        }
        List<Injection> list = this.getInjections(clazz.getCanonicalName());
        if (list == null) {
            return null;
        }
        Iterator<Injection> iterator = list.iterator();
        Injection injection = null;
        while (iterator.hasNext() && injection == null) {
            Injection injection2 = iterator.next();
            if (!injection2.isMethod() || !injection2.getTarget().getName().equals(method.getName()) || !clazz2.equals(injection2.getParamClass())) continue;
            injection = injection2;
        }
        return injection;
    }

    public void inject(Object object) {
        if (object == null) {
            return;
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List<Injection> list = this._injectionMap.get(clazz.getCanonicalName());
            if (list == null) continue;
            for (Injection injection : list) {
                injection.inject(object);
            }
        }
    }
}

