/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.naming.InitialContext;
import org.eclipse.jetty.util.IntrospectionUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Injection {
    private static final Logger LOG = Log.getLogger(Injection.class);
    private Class<?> _targetClass;
    private String _jndiName;
    private String _mappingName;
    private Member _target;
    private Class<?> _paramClass;
    private Class<?> _resourceClass;

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public Class<?> getParamClass() {
        return this._paramClass;
    }

    public Class<?> getResourceClass() {
        return this._resourceClass;
    }

    public boolean isField() {
        return this._target != null && this._target instanceof Field;
    }

    public boolean isMethod() {
        return this._target != null && this._target instanceof Method;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String string) {
        this._jndiName = string;
    }

    public String getMappingName() {
        return this._mappingName;
    }

    public void setMappingName(String string) {
        this._mappingName = string;
    }

    public Member getTarget() {
        return this._target;
    }

    public void setTarget(Class<?> clazz, Field field, Class<?> clazz2) {
        this._targetClass = clazz;
        this._target = field;
        this._resourceClass = clazz2;
    }

    public void setTarget(Class<?> clazz, Method method, Class<?> clazz2, Class<?> clazz3) {
        this._targetClass = clazz;
        this._target = method;
        this._resourceClass = clazz3;
        this._paramClass = clazz2;
    }

    public void setTarget(Class<?> clazz, String string, Class<?> clazz2) {
        this._targetClass = clazz;
        this._resourceClass = clazz2;
        String string2 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
        try {
            LOG.debug("Looking for method for setter: " + string2 + " with arg " + this._resourceClass, new Object[0]);
            this._target = IntrospectionUtil.findMethod(clazz, (String)string2, (Class[])new Class[]{this._resourceClass}, (boolean)true, (boolean)false);
            this._targetClass = clazz;
            this._paramClass = this._resourceClass;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                this._target = IntrospectionUtil.findField(clazz, (String)string, clazz2, (boolean)true, (boolean)false);
                this._targetClass = clazz;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException("No such field or method " + string + " on class " + this._targetClass);
            }
        }
    }

    public void inject(Object object) {
        if (this._target != null) {
            if (this._target instanceof Field) {
                this.injectField((Field)this._target, object);
            } else {
                this.injectMethod((Method)this._target, object);
            }
        } else {
            throw new IllegalStateException("No method or field to inject with " + this.getJndiName());
        }
    }

    public Object lookupInjectedValue() {
        InitialContext initialContext = new InitialContext();
        return initialContext.lookup("java:comp/env/" + this.getJndiName());
    }

    protected void injectField(Field field, Object object) {
        try {
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            field.set(object, this.lookupInjectedValue());
            field.setAccessible(bl);
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
            throw new IllegalStateException("Inject failed for field " + field.getName());
        }
    }

    protected void injectMethod(Method method, Object object) {
        try {
            boolean bl = method.isAccessible();
            method.setAccessible(true);
            method.invoke(object, this.lookupInjectedValue());
            method.setAccessible(bl);
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
            throw new IllegalStateException("Inject failed for method " + method.getName());
        }
    }
}

