/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class ContainerInitializer {
    private static final Logger LOG = Log.getLogger(ContainerInitializer.class);
    protected final ServletContainerInitializer _target;
    protected final Class<?>[] _interestedTypes;
    protected final Set<String> _applicableTypeNames = new ConcurrentHashSet();
    protected final Set<String> _annotatedTypeNames = new ConcurrentHashSet();

    public ContainerInitializer(ServletContainerInitializer servletContainerInitializer, Class<?>[] classArray) {
        this._target = servletContainerInitializer;
        this._interestedTypes = classArray;
    }

    public ContainerInitializer(ClassLoader classLoader, String string) {
        Matcher matcher = Pattern.compile("ContainerInitializer\\{(.*),interested=(.*),applicable=(.*),annotated=(.*)\\}").matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        try {
            this._target = (ServletContainerInitializer)classLoader.loadClass(matcher.group(1)).newInstance();
            String[] stringArray = StringUtil.arrayFromString((String)matcher.group(2));
            this._interestedTypes = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this._interestedTypes[i] = classLoader.loadClass(stringArray[i]);
            }
            for (String string2 : StringUtil.arrayFromString((String)matcher.group(3))) {
                this._applicableTypeNames.add(string2);
            }
            for (String string2 : StringUtil.arrayFromString((String)matcher.group(4))) {
                this._annotatedTypeNames.add(string2);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string, exception);
        }
    }

    public ServletContainerInitializer getTarget() {
        return this._target;
    }

    public Class[] getInterestedTypes() {
        return this._interestedTypes;
    }

    public void addAnnotatedTypeName(String string) {
        this._annotatedTypeNames.add(string);
    }

    public Set<String> getAnnotatedTypeNames() {
        return Collections.unmodifiableSet(this._annotatedTypeNames);
    }

    public void addApplicableTypeName(String string) {
        this._applicableTypeNames.add(string);
    }

    public Set<String> getApplicableTypeNames() {
        return Collections.unmodifiableSet(this._applicableTypeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartup(WebAppContext webAppContext) {
        if (this._target != null) {
            HashSet<Class> hashSet = new HashSet<Class>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
            try {
                for (String string : this._applicableTypeNames) {
                    hashSet.add(Loader.loadClass(webAppContext.getClass(), (String)string));
                }
                webAppContext.getServletContext().setExtendedListenerTypes(true);
                if (LOG.isDebugEnabled()) {
                    long l = System.nanoTime();
                    this._target.onStartup(hashSet, (ServletContext)webAppContext.getServletContext());
                    LOG.debug("ContainerInitializer {} called in {}ms", new Object[]{this._target.getClass().getName(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS)});
                } else {
                    this._target.onStartup(hashSet, (ServletContext)webAppContext.getServletContext());
                }
            }
            finally {
                webAppContext.getServletContext().setExtendedListenerTypes(false);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public String toString() {
        List list = Collections.emptyList();
        if (this._interestedTypes != null) {
            list = new ArrayList(this._interestedTypes.length);
            for (Class<?> clazz : this._interestedTypes) {
                list.add(clazz.getName());
            }
        }
        return String.format("ContainerInitializer{%s,interested=%s,applicable=%s,annotated=%s}", this._target.getClass().getName(), list, this._applicableTypeNames, this._annotatedTypeNames);
    }

    public void resolveClasses(WebAppContext webAppContext, Map<String, Set<String>> map) {
        Set<String> set = this.getAnnotatedTypeNames();
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                this.addApplicableTypeName(string);
                this.addInheritedTypes(map, map.get(string));
            }
        }
        if (this.getInterestedTypes() != null) {
            for (Class clazz : this.getInterestedTypes()) {
                if (clazz.isAnnotation()) continue;
                this.addInheritedTypes(map, map.get(clazz.getName()));
            }
        }
    }

    private void addInheritedTypes(Map<String, Set<String>> map, Set<String> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (String string : set) {
            this.addApplicableTypeName(string);
            this.addInheritedTypes(map, map.get(string));
        }
    }
}

