/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientConnectionFactory
implements ClientConnectionFactory {
    public static final String SSL_CONTEXT_FACTORY_CONTEXT_KEY = "ssl.context.factory";
    public static final String SSL_PEER_HOST_CONTEXT_KEY = "ssl.peer.host";
    public static final String SSL_PEER_PORT_CONTEXT_KEY = "ssl.peer.port";
    public static final String SSL_ENGINE_CONTEXT_KEY = "ssl.engine";
    private final SslContextFactory sslContextFactory;
    private final ByteBufferPool byteBufferPool;
    private final Executor executor;
    private final ClientConnectionFactory connectionFactory;

    public SslClientConnectionFactory(SslContextFactory sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory clientConnectionFactory) {
        this.sslContextFactory = sslContextFactory;
        this.byteBufferPool = byteBufferPool;
        this.executor = executor;
        this.connectionFactory = clientConnectionFactory;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> map) {
        String string = (String)map.get(SSL_PEER_HOST_CONTEXT_KEY);
        int n = (Integer)map.get(SSL_PEER_PORT_CONTEXT_KEY);
        SSLEngine sSLEngine = this.sslContextFactory.newSSLEngine(string, n);
        sSLEngine.setUseClientMode(true);
        map.put(SSL_ENGINE_CONTEXT_KEY, sSLEngine);
        SslConnection sslConnection = this.newSslConnection(this.byteBufferPool, this.executor, endPoint, sSLEngine);
        sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
        endPoint.setConnection(sslConnection);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        decryptedEndPoint.setConnection(this.connectionFactory.newConnection(decryptedEndPoint, map));
        return sslConnection;
    }

    protected SslConnection newSslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sSLEngine) {
        return new SslConnection(byteBufferPool, executor, endPoint, sSLEngine);
    }
}

