/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class WriterOutputStream
extends OutputStream {
    protected final Writer _writer;
    protected final Charset _encoding;
    private final byte[] _buf = new byte[1];

    public WriterOutputStream(Writer writer, String string) {
        this._writer = writer;
        this._encoding = string == null ? null : Charset.forName(string);
    }

    public WriterOutputStream(Writer writer) {
        this._writer = writer;
        this._encoding = null;
    }

    @Override
    public void close() {
        this._writer.close();
    }

    @Override
    public void flush() {
        this._writer.flush();
    }

    @Override
    public void write(byte[] byArray) {
        if (this._encoding == null) {
            this._writer.write(new String(byArray));
        } else {
            this._writer.write(new String(byArray, this._encoding));
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this._encoding == null) {
            this._writer.write(new String(byArray, n, n2));
        } else {
            this._writer.write(new String(byArray, n, n2, this._encoding));
        }
    }

    @Override
    public synchronized void write(int n) {
        this._buf[0] = (byte)n;
        this.write(this._buf);
    }
}

