/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritePendingException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class WriteFlusher {
    private static final Logger LOG = Log.getLogger(WriteFlusher.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[]{BufferUtil.EMPTY_BUFFER};
    private static final EnumMap<StateType, Set<StateType>> __stateTransitions = new EnumMap(StateType.class);
    private static final State __IDLE = new IdleState();
    private static final State __WRITING = new WritingState();
    private static final State __COMPLETING = new CompletingState();
    private final EndPoint _endPoint;
    private final AtomicReference<State> _state = new AtomicReference();

    protected WriteFlusher(EndPoint endPoint) {
        this._state.set(__IDLE);
        this._endPoint = endPoint;
    }

    private boolean updateState(State state, State state2) {
        if (!this.isTransitionAllowed(state, state2)) {
            throw new IllegalStateException();
        }
        boolean bl = this._state.compareAndSet(state, state2);
        if (DEBUG) {
            LOG.debug("update {}:{}{}{}", new Object[]{this, state, bl ? "-->" : "!->", state2});
        }
        return bl;
    }

    private void fail(PendingState pendingState) {
        FailedState failedState;
        State state = this._state.get();
        if (state.getType() == StateType.FAILED && this.updateState(failedState = (FailedState)state, __IDLE)) {
            pendingState.fail(failedState.getCause());
            return;
        }
        throw new IllegalStateException();
    }

    private void ignoreFail() {
        State state = this._state.get();
        while (state.getType() == StateType.FAILED) {
            if (this.updateState(state, __IDLE)) {
                return;
            }
            state = this._state.get();
        }
    }

    private boolean isTransitionAllowed(State state, State state2) {
        Set<StateType> set = __stateTransitions.get((Object)state.getType());
        if (!set.contains((Object)state2.getType())) {
            LOG.warn("{}: {} -> {} not allowed", new Object[]{this, state, state2});
            return false;
        }
        return true;
    }

    public boolean isCallbackNonBlocking() {
        State state = this._state.get();
        return state instanceof PendingState && ((PendingState)state).isCallbackNonBlocking();
    }

    protected abstract void onIncompleteFlush();

    public void write(Callback callback, ByteBuffer ... byteBufferArray) {
        if (DEBUG) {
            LOG.debug("write: {} {}", new Object[]{this, BufferUtil.toDetailString((ByteBuffer[])byteBufferArray)});
        }
        if (!this.updateState(__IDLE, __WRITING)) {
            throw new WritePendingException();
        }
        try {
            byteBufferArray = this.flush(byteBufferArray);
            if (byteBufferArray != null) {
                PendingState pendingState;
                if (DEBUG) {
                    LOG.debug("flushed incomplete", new Object[0]);
                }
                if (this.updateState(__WRITING, pendingState = new PendingState(byteBufferArray, callback))) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(pendingState);
                }
                return;
            }
            if (!this.updateState(__WRITING, __IDLE)) {
                this.ignoreFail();
            }
            if (callback != null) {
                callback.succeeded();
            }
        }
        catch (IOException iOException) {
            if (DEBUG) {
                LOG.debug("write exception", (Throwable)iOException);
            }
            if (this.updateState(__WRITING, __IDLE)) {
                if (callback != null) {
                    callback.failed((Throwable)iOException);
                }
            }
            this.fail(new PendingState(byteBufferArray, callback));
        }
    }

    public void completeWrite() {
        State state;
        if (DEBUG) {
            LOG.debug("completeWrite: {}", new Object[]{this});
        }
        if ((state = this._state.get()).getType() != StateType.PENDING) {
            return;
        }
        PendingState pendingState = (PendingState)state;
        if (!this.updateState(pendingState, __COMPLETING)) {
            return;
        }
        try {
            ByteBuffer[] byteBufferArray = pendingState.getBuffers();
            byteBufferArray = this.flush(byteBufferArray);
            if (byteBufferArray != null) {
                if (DEBUG) {
                    LOG.debug("flushed incomplete {}", new Object[]{BufferUtil.toDetailString((ByteBuffer[])byteBufferArray)});
                }
                if (byteBufferArray != pendingState.getBuffers()) {
                    pendingState = new PendingState(byteBufferArray, pendingState._callback);
                }
                if (this.updateState(__COMPLETING, pendingState)) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(pendingState);
                }
                return;
            }
            if (!this.updateState(__COMPLETING, __IDLE)) {
                this.ignoreFail();
            }
            pendingState.complete();
        }
        catch (IOException iOException) {
            if (DEBUG) {
                LOG.debug("completeWrite exception", (Throwable)iOException);
            }
            if (this.updateState(__COMPLETING, __IDLE)) {
                pendingState.fail(iOException);
            }
            this.fail(pendingState);
        }
    }

    protected ByteBuffer[] flush(ByteBuffer[] byteBufferArray) {
        boolean bl = true;
        while (bl && byteBufferArray != null) {
            int n;
            int n2 = byteBufferArray.length == 0 ? 0 : byteBufferArray[0].remaining();
            boolean bl2 = this._endPoint.flush(byteBufferArray);
            int n3 = n = byteBufferArray.length == 0 ? 0 : byteBufferArray[0].remaining();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed={} {}/{}+{} {}", new Object[]{bl2, n2 - n, n2, byteBufferArray.length - 1, this});
            }
            if (bl2) {
                return null;
            }
            bl = n2 != n;
            int n4 = 0;
            while (n == 0) {
                if (++n4 == byteBufferArray.length) {
                    byteBufferArray = null;
                    n4 = 0;
                    break;
                }
                bl = true;
                n = byteBufferArray[n4].remaining();
            }
            if (n4 <= 0) continue;
            byteBufferArray = Arrays.copyOfRange(byteBufferArray, n4, byteBufferArray.length);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!fully flushed {}", new Object[]{this});
        }
        return byteBufferArray == null ? EMPTY_BUFFERS : byteBufferArray;
    }

    public boolean onFail(Throwable throwable) {
        block4: while (true) {
            State state = this._state.get();
            switch (state.getType()) {
                case IDLE: 
                case FAILED: {
                    if (DEBUG) {
                        LOG.debug("ignored: {} {}", new Object[]{this, throwable});
                    }
                    return false;
                }
                case PENDING: {
                    PendingState pendingState;
                    if (DEBUG) {
                        LOG.debug("failed: {} {}", new Object[]{this, throwable});
                    }
                    if (!this.updateState(pendingState = (PendingState)state, __IDLE)) continue block4;
                    return pendingState.fail(throwable);
                }
            }
            if (DEBUG) {
                LOG.debug("failed: {} {}", new Object[]{this, throwable});
            }
            if (this.updateState(state, new FailedState(throwable))) break;
        }
        return false;
    }

    public void onClose() {
        if (this._state.get() == __IDLE) {
            return;
        }
        this.onFail(new ClosedChannelException());
    }

    boolean isIdle() {
        return this._state.get().getType() == StateType.IDLE;
    }

    public boolean isInProgress() {
        switch (this._state.get().getType()) {
            case PENDING: 
            case WRITING: 
            case COMPLETING: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("WriteFlusher@%x{%s}", this.hashCode(), this._state.get());
    }

    public String toStateString() {
        switch (this._state.get().getType()) {
            case WRITING: {
                return "W";
            }
            case PENDING: {
                return "P";
            }
            case COMPLETING: {
                return "C";
            }
            case IDLE: {
                return "-";
            }
            case FAILED: {
                return "F";
            }
        }
        return "?";
    }

    static {
        __stateTransitions.put(StateType.IDLE, EnumSet.of(StateType.WRITING));
        __stateTransitions.put(StateType.WRITING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.PENDING, EnumSet.of(StateType.COMPLETING, StateType.IDLE));
        __stateTransitions.put(StateType.COMPLETING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.FAILED, EnumSet.of(StateType.IDLE));
    }

    private class PendingState
    extends State {
        private final Callback _callback;
        private final ByteBuffer[] _buffers;

        private PendingState(ByteBuffer[] byteBufferArray, Callback callback) {
            super(StateType.PENDING);
            this._buffers = byteBufferArray;
            this._callback = callback;
        }

        public ByteBuffer[] getBuffers() {
            return this._buffers;
        }

        protected boolean fail(Throwable throwable) {
            if (this._callback != null) {
                this._callback.failed(throwable);
                return true;
            }
            return false;
        }

        protected void complete() {
            if (this._callback != null) {
                this._callback.succeeded();
            }
        }

        boolean isCallbackNonBlocking() {
            return this._callback != null && this._callback.isNonBlocking();
        }
    }

    private static class CompletingState
    extends State {
        private CompletingState() {
            super(StateType.COMPLETING);
        }
    }

    private static class FailedState
    extends State {
        private final Throwable _cause;

        private FailedState(Throwable throwable) {
            super(StateType.FAILED);
            this._cause = throwable;
        }

        public Throwable getCause() {
            return this._cause;
        }
    }

    private static class WritingState
    extends State {
        private WritingState() {
            super(StateType.WRITING);
        }
    }

    private static class IdleState
    extends State {
        private IdleState() {
            super(StateType.IDLE);
        }
    }

    private static class State {
        private final StateType _type;

        private State(StateType stateType) {
            this._type = stateType;
        }

        public StateType getType() {
            return this._type;
        }

        public String toString() {
            return String.format("%s", new Object[]{this._type});
        }
    }

    private static enum StateType {
        IDLE,
        WRITING,
        PENDING,
        COMPLETING,
        FAILED;

    }
}

