/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class SelectorManager
extends AbstractLifeCycle
implements Dumpable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private long _connectTimeout = 15000L;
    private long _selectorIndex;

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, (Runtime.getRuntime().availableProcessors() + 1) / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("No selectors");
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[n];
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long l) {
        this._connectTimeout = l;
    }

    @Deprecated
    public int getSelectorPriorityDelta() {
        return 0;
    }

    @Deprecated
    public void setSelectorPriorityDelta(int n) {
    }

    protected void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector(SocketChannel socketChannel) {
        int n;
        ManagedSelector managedSelector = null;
        if (socketChannel != null) {
            try {
                byte[] byArray;
                SocketAddress socketAddress = socketChannel.getRemoteAddress();
                if (socketAddress instanceof InetSocketAddress && (byArray = ((InetSocketAddress)socketAddress).getAddress().getAddress()) != null) {
                    n = byArray[byArray.length - 1] & 0xFF;
                    managedSelector = this._selectors[n % this.getSelectorCount()];
                }
            }
            catch (IOException iOException) {
                LOG.ignore((Throwable)iOException);
            }
        }
        long l = this._selectorIndex++;
        n = (int)(l % (long)this.getSelectorCount());
        ManagedSelector managedSelector2 = this._selectors[n];
        if (managedSelector == null || managedSelector.size() >= managedSelector2.size() * 2) {
            return managedSelector2;
        }
        return managedSelector;
    }

    public void connect(SocketChannel socketChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector(socketChannel);
        managedSelector2.getClass();
        managedSelector.submit(managedSelector2.new ManagedSelector.Connect(socketChannel, object));
    }

    public void accept(SocketChannel socketChannel) {
        this.accept(socketChannel, null);
    }

    public void accept(SocketChannel socketChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector(socketChannel);
        managedSelector2.getClass();
        managedSelector.submit(managedSelector2.new ManagedSelector.Accept(socketChannel, object));
    }

    public void acceptor(ServerSocketChannel serverSocketChannel) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector(null);
        managedSelector2.getClass();
        managedSelector.submit(managedSelector2.new ManagedSelector.Acceptor(serverSocketChannel));
    }

    protected void accepted(SocketChannel socketChannel) {
        throw new UnsupportedOperationException();
    }

    protected void doStart() {
        super.doStart();
        for (int i = 0; i < this._selectors.length; ++i) {
            ManagedSelector managedSelector;
            this._selectors[i] = managedSelector = this.newSelector(i);
            managedSelector.start();
            this.execute(managedSelector);
        }
    }

    protected ManagedSelector newSelector(int n) {
        return new ManagedSelector(this, n);
    }

    protected void doStop() {
        for (ManagedSelector managedSelector : this._selectors) {
            managedSelector.stop();
        }
        super.doStop();
    }

    protected void endPointOpened(EndPoint endPoint) {
        endPoint.onOpen();
    }

    protected void endPointClosed(EndPoint endPoint) {
        endPoint.onClose();
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable throwable) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, throwable);
            }
            LOG.debug("Exception while notifying connection " + connection, throwable);
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable throwable) {
            LOG.debug("Exception while notifying connection " + connection, throwable);
        }
    }

    protected boolean finishConnect(SocketChannel socketChannel) {
        return socketChannel.finishConnect();
    }

    protected void connectionFailed(SocketChannel socketChannel, Throwable throwable, Object object) {
        LOG.warn(String.format("%s - %s", socketChannel, object), throwable);
    }

    protected abstract EndPoint newEndPoint(SocketChannel var1, ManagedSelector var2, SelectionKey var3);

    public abstract Connection newConnection(SocketChannel var1, EndPoint var2, Object var3);

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable appendable, String string) {
        ContainerLifeCycle.dumpObject((Appendable)appendable, (Object)((Object)this));
        ContainerLifeCycle.dump((Appendable)appendable, (String)string, (Collection[])new Collection[]{TypeUtil.asList((Object[])this._selectors)});
    }
}

