/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements ManagedSelector.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final Locker _locker = new Locker();
    private boolean _updatePending;
    private final AtomicBoolean _open = new AtomicBoolean();
    private final ManagedSelector _selector;
    private final SelectionKey _key;
    private int _currentInterestOps;
    private int _desiredInterestOps;
    private final Runnable _runUpdateKey = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.updateKey();
        }

        public String toString() {
            return SelectChannelEndPoint.this.toString() + ":runUpdateKey";
        }
    };
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getFillInterest().fillable();
        }

        public String toString() {
            return SelectChannelEndPoint.this.toString() + ":runFillable";
        }
    };
    private final Runnable _runCompleteWrite = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        public String toString() {
            return SelectChannelEndPoint.this.toString() + ":runCompleteWrite";
        }
    };
    private final Runnable _runFillableCompleteWrite = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.getFillInterest().fillable();
            SelectChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        public String toString() {
            return SelectChannelEndPoint.this.toString() + ":runFillableCompleteWrite";
        }
    };

    public SelectChannelEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey, Scheduler scheduler, long l) {
        super(scheduler, socketChannel);
        this._selector = managedSelector;
        this._key = selectionKey;
        this.setIdleTimeout(l);
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    @Override
    public Runnable onSelected() {
        Runnable runnable;
        boolean bl;
        int n;
        int n2;
        int n3 = this._key.readyOps();
        try (Locker.Lock lock = this._locker.lock();){
            this._updatePending = true;
            n2 = this._desiredInterestOps;
            this._desiredInterestOps = n = n2 & ~n3;
        }
        boolean bl2 = (n3 & 1) != 0;
        boolean bl3 = bl = (n3 & 4) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} r={} w={} for {}", new Object[]{n2, n, bl2, bl, this});
        }
        if (bl2 && this.getFillInterest().isCallbackNonBlocking()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Direct readable run {}", new Object[]{this});
            }
            this._runFillable.run();
            bl2 = false;
        }
        if (bl && this.getWriteFlusher().isCallbackNonBlocking()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Direct writable run {}", new Object[]{this});
            }
            this._runCompleteWrite.run();
            bl = false;
        }
        Runnable runnable2 = bl2 ? (bl ? this._runFillableCompleteWrite : this._runFillable) : (runnable = bl ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", new Object[]{runnable});
        }
        return runnable;
    }

    @Override
    public void updateKey() {
        try {
            int n;
            int n2;
            try (Locker.Lock lock = this._locker.lock();){
                this._updatePending = false;
                n2 = this._currentInterestOps;
                n = this._desiredInterestOps;
                if (n2 != n) {
                    this._currentInterestOps = n;
                    this._key.interestOps(n);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", new Object[]{n2, n, this});
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            LOG.debug("Ignoring key update for concurrently closed channel {}", new Object[]{this});
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Ignoring key update for " + this, throwable);
            this.close();
        }
    }

    private void changeInterests(int n) {
        int n2;
        int n3;
        boolean bl;
        try (Locker.Lock lock = this._locker.lock();){
            bl = this._updatePending;
            n3 = this._desiredInterestOps;
            n2 = n3 | n;
            if (n2 != n3) {
                this._desiredInterestOps = n2;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", new Object[]{bl, n3, n2, this});
        }
        if (!bl) {
            this._selector.submit(this._runUpdateKey);
        }
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
        }
    }

    @Override
    public String toString() {
        try {
            boolean bl = this._key != null && this._key.isValid();
            int n = bl ? this._key.interestOps() : -1;
            int n2 = bl ? this._key.readyOps() : -1;
            return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toString(), this._currentInterestOps, this._desiredInterestOps, n, n2);
        }
        catch (Throwable throwable) {
            return String.format("%s{io=%s,kio=-2,kro=-2}", super.toString(), this._desiredInterestOps);
        }
    }
}

