/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class NetworkTrafficSelectChannelEndPoint
extends SelectChannelEndPoint {
    private static final Logger LOG = Log.getLogger(NetworkTrafficSelectChannelEndPoint.class);
    private final List<NetworkTrafficListener> listeners;

    public NetworkTrafficSelectChannelEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey, Scheduler scheduler, long l, List<NetworkTrafficListener> list) {
        super(socketChannel, managedSelector, selectionKey, scheduler, l);
        this.listeners = list;
    }

    @Override
    public int fill(ByteBuffer byteBuffer) {
        int n = super.fill(byteBuffer);
        this.notifyIncoming(byteBuffer, n);
        return n;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) {
        boolean bl = true;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            int n = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[]{byteBuffer};
            int n2 = byteBuffer.position() - n;
            byteBuffer2.limit(byteBuffer2.position() + n2);
            this.notifyOutgoing(byteBuffer2);
            if (!(bl &= super.flush(byteBufferArray2))) break;
        }
        return bl;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.opened(this.getSocket());
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.closed(this.getSocket());
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        }
    }

    public void notifyIncoming(ByteBuffer byteBuffer, int n) {
        if (this.listeners != null && !this.listeners.isEmpty() && n > 0) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
                    networkTrafficListener.incoming(this.getSocket(), byteBuffer2);
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        }
    }

    public void notifyOutgoing(ByteBuffer byteBuffer) {
        if (this.listeners != null && !this.listeners.isEmpty() && byteBuffer.hasRemaining()) {
            Socket socket = this.getSocket();
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.outgoing(socket, byteBuffer);
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        }
    }
}

