/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class MappedByteBufferPool
implements ByteBufferPool {
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> directBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> heapBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final int factor;

    public MappedByteBufferPool() {
        this(1024);
    }

    public MappedByteBufferPool(int n) {
        this.factor = n;
    }

    @Override
    public ByteBuffer acquire(int n, boolean bl) {
        int n2 = this.bucketFor(n);
        ConcurrentMap<Integer, Queue<ByteBuffer>> concurrentMap = this.buffersFor(bl);
        ByteBuffer byteBuffer = null;
        Queue queue = (Queue)concurrentMap.get(n2);
        if (queue != null) {
            byteBuffer = (ByteBuffer)queue.poll();
        }
        if (byteBuffer == null) {
            int n3 = n2 * this.factor;
            byteBuffer = this.newByteBuffer(n3, bl);
        }
        BufferUtil.clear((ByteBuffer)byteBuffer);
        return byteBuffer;
    }

    protected ByteBuffer newByteBuffer(int n, boolean bl) {
        return bl ? BufferUtil.allocateDirect((int)n) : BufferUtil.allocate((int)n);
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        assert (byteBuffer.capacity() % this.factor == 0);
        int n = this.bucketFor(byteBuffer.capacity());
        ConcurrentMap<Integer, Queue<ByteBuffer>> concurrentMap = this.buffersFor(byteBuffer.isDirect());
        Queue<ByteBuffer> queue = (ConcurrentLinkedQueue<ByteBuffer>)concurrentMap.get(n);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<ByteBuffer>();
            Queue queue2 = concurrentMap.putIfAbsent(n, queue);
            if (queue2 != null) {
                queue = queue2;
            }
        }
        BufferUtil.clear((ByteBuffer)byteBuffer);
        queue.offer(byteBuffer);
    }

    public void clear() {
        this.directBuffers.clear();
        this.heapBuffers.clear();
    }

    private int bucketFor(int n) {
        int n2 = n / this.factor;
        if (n % this.factor > 0) {
            ++n2;
        }
        return n2;
    }

    ConcurrentMap<Integer, Queue<ByteBuffer>> buffersFor(boolean bl) {
        return bl ? this.directBuffers : this.heapBuffers;
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        @Override
        protected ByteBuffer newByteBuffer(int n, boolean bl) {
            ByteBuffer byteBuffer = super.newByteBuffer(n + 4, bl);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.putInt(this.tag.incrementAndGet());
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            BufferUtil.clear((ByteBuffer)byteBuffer2);
            return byteBuffer2;
        }
    }
}

