/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class ManagedSelector
extends AbstractLifeCycle
implements Runnable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ManagedSelector.class);
    private final Locker _locker = new Locker();
    private boolean _selecting = false;
    private final Queue<Runnable> _actions = new ArrayDeque<Runnable>();
    private final SelectorManager _selectorManager;
    private final int _id;
    private final ExecutionStrategy _strategy;
    private Selector _selector;

    public ManagedSelector(SelectorManager selectorManager, int n) {
        this._selectorManager = selectorManager;
        this._id = n;
        this._strategy = ExecutionStrategy.Factory.instanceFor((ExecutionStrategy.Producer)new SelectorProducer(), (Executor)selectorManager.getExecutor());
        this.setStopTimeout(5000L);
    }

    protected void doStart() {
        super.doStart();
        this._selector = this.newSelector();
    }

    protected Selector newSelector() {
        return Selector.open();
    }

    public int size() {
        Selector selector = this._selector;
        if (selector == null) {
            return 0;
        }
        return selector.keys().size();
    }

    protected void doStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", new Object[]{this});
        }
        CloseEndPoints closeEndPoints = new CloseEndPoints();
        this.submit(closeEndPoints);
        closeEndPoints.await(this.getStopTimeout());
        super.doStop();
        CloseSelector closeSelector = new CloseSelector();
        this.submit(closeSelector);
        closeSelector.await(this.getStopTimeout());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", new Object[]{this});
        }
    }

    public void submit(Runnable runnable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued change {} on {}", new Object[]{runnable, this});
        }
        Selector selector = null;
        try (Locker.Lock lock = this._locker.lock();){
            this._actions.offer(runnable);
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            selector.wakeup();
        }
    }

    @Override
    public void run() {
        this._strategy.execute();
    }

    private Runnable processConnect(SelectionKey selectionKey, final Connect connect) {
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        try {
            selectionKey.attach(connect.attachment);
            boolean bl = this._selectorManager.finishConnect(socketChannel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected {} {}", new Object[]{bl, socketChannel});
            }
            if (bl) {
                if (connect.timeout.cancel()) {
                    selectionKey.interestOps(0);
                    return new CreateEndPoint(socketChannel, selectionKey){

                        @Override
                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            connect.failed(throwable);
                        }
                    };
                }
                throw new SocketTimeoutException("Concurrent Connect Timeout");
            }
            throw new ConnectException();
        }
        catch (Throwable throwable) {
            connect.failed(throwable);
            return null;
        }
    }

    private void processAccept(SelectionKey selectionKey) {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        SocketChannel socketChannel = null;
        try {
            while ((socketChannel = serverSocketChannel.accept()) != null) {
                this._selectorManager.accepted(socketChannel);
            }
        }
        catch (Throwable throwable) {
            this.closeNoExceptions(socketChannel);
            LOG.warn("Accept failed for channel " + socketChannel, throwable);
        }
    }

    private void closeNoExceptions(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
        }
    }

    private EndPoint createEndPoint(SocketChannel socketChannel, SelectionKey selectionKey) {
        EndPoint endPoint = this._selectorManager.newEndPoint(socketChannel, this, selectionKey);
        this._selectorManager.endPointOpened(endPoint);
        Connection connection = this._selectorManager.newConnection(socketChannel, endPoint, selectionKey.attachment());
        endPoint.setConnection(connection);
        selectionKey.attach(endPoint);
        this._selectorManager.connectionOpened(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{endPoint});
        }
        return endPoint;
    }

    public void destroyEndPoint(final EndPoint endPoint) {
        final Connection connection = endPoint.getConnection();
        this.submit(new Product(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Destroyed {}", new Object[]{endPoint});
                }
                if (connection != null) {
                    ManagedSelector.this._selectorManager.connectionClosed(connection);
                }
                ManagedSelector.this._selectorManager.endPointClosed(endPoint);
            }
        });
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable appendable, String string) {
        appendable.append(String.valueOf(this)).append(" id=").append(String.valueOf(this._id)).append(System.lineSeparator());
        Selector selector = this._selector;
        if (selector != null && selector.isOpen()) {
            ArrayList arrayList = new ArrayList(selector.keys().size() * 2);
            DumpKeys dumpKeys = new DumpKeys(arrayList);
            this.submit(dumpKeys);
            dumpKeys.await(5L, TimeUnit.SECONDS);
            ContainerLifeCycle.dump((Appendable)appendable, (String)string, (Collection[])new Collection[]{arrayList});
        }
    }

    public String toString() {
        Selector selector = this._selector;
        return String.format("%s id=%s keys=%d selected=%d", super.toString(), this._id, selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1);
    }

    private class CloseSelector
    implements Runnable {
        private CountDownLatch _latch = new CountDownLatch(1);

        private CloseSelector() {
        }

        @Override
        public void run() {
            Selector selector = ManagedSelector.this._selector;
            ManagedSelector.this._selector = null;
            ManagedSelector.this.closeNoExceptions(selector);
            this._latch.countDown();
        }

        public boolean await(long l) {
            try {
                return this._latch.await(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    private class EndPointCloser
    implements Product {
        private final EndPoint _endPoint;
        private final CountDownLatch _latch;

        private EndPointCloser(EndPoint endPoint, CountDownLatch countDownLatch) {
            this._endPoint = endPoint;
            this._latch = countDownLatch;
        }

        @Override
        public void run() {
            ManagedSelector.this.closeNoExceptions(this._endPoint.getConnection());
            this._latch.countDown();
        }
    }

    private class CloseEndPoints
    implements Runnable {
        private final CountDownLatch _latch = new CountDownLatch(1);
        private CountDownLatch _allClosed;

        private CloseEndPoints() {
        }

        @Override
        public void run() {
            ArrayList<EndPoint> arrayList = new ArrayList<EndPoint>();
            for (SelectionKey object : ManagedSelector.this._selector.keys()) {
                Object object2;
                if (!object.isValid() || !((object2 = object.attachment()) instanceof EndPoint)) continue;
                arrayList.add((EndPoint)object2);
            }
            int n = arrayList.size();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {} endPoints on {}", new Object[]{n, ManagedSelector.this});
            }
            this._allClosed = new CountDownLatch(n);
            this._latch.countDown();
            for (EndPoint endPoint : arrayList) {
                ManagedSelector.this.submit(new EndPointCloser(endPoint, this._allClosed));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {} endPoints on {}", new Object[]{n, ManagedSelector.this});
            }
        }

        public boolean await(long l) {
            try {
                return this._latch.await(l, TimeUnit.MILLISECONDS) && this._allClosed.await(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    private class ConnectTimeout
    implements Runnable {
        private final Connect connect;

        private ConnectTimeout(Connect connect) {
            this.connect = connect;
        }

        @Override
        public void run() {
            SocketChannel socketChannel = this.connect.channel;
            if (socketChannel.isConnectionPending()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", new Object[]{socketChannel});
                }
                this.connect.failed(new SocketTimeoutException("Connect Timeout"));
            }
        }
    }

    class Connect
    implements Runnable {
        private final AtomicBoolean failed = new AtomicBoolean();
        private final SocketChannel channel;
        private final Object attachment;
        private final Scheduler.Task timeout;

        Connect(SocketChannel socketChannel, Object object) {
            this.channel = socketChannel;
            this.attachment = object;
            this.timeout = ManagedSelector.this._selectorManager.getScheduler().schedule((Runnable)new ConnectTimeout(this), ManagedSelector.this._selectorManager.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                this.channel.register(ManagedSelector.this._selector, 8, this);
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        private void failed(Throwable throwable) {
            if (this.failed.compareAndSet(false, true)) {
                this.timeout.cancel();
                ManagedSelector.this.closeNoExceptions(this.channel);
                ManagedSelector.this._selectorManager.connectionFailed(this.channel, throwable, this.attachment);
            }
        }
    }

    private class CreateEndPoint
    implements Product {
        private final SocketChannel channel;
        private final SelectionKey key;

        public CreateEndPoint(SocketChannel socketChannel, SelectionKey selectionKey) {
            this.channel = socketChannel;
            this.key = selectionKey;
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this.channel, this.key);
            }
            catch (Throwable throwable) {
                LOG.debug(throwable);
                this.failed(throwable);
            }
        }

        protected void failed(Throwable throwable) {
            ManagedSelector.this.closeNoExceptions(this.channel);
            LOG.debug(throwable);
        }
    }

    class Accept
    implements Runnable {
        private final SocketChannel channel;
        private final Object attachment;

        Accept(SocketChannel socketChannel, Object object) {
            this.channel = socketChannel;
            this.attachment = object;
        }

        @Override
        public void run() {
            try {
                SelectionKey selectionKey = this.channel.register(ManagedSelector.this._selector, 0, this.attachment);
                ManagedSelector.this.submit(new CreateEndPoint(this.channel, selectionKey));
            }
            catch (Throwable throwable) {
                ManagedSelector.this.closeNoExceptions(this.channel);
                LOG.debug(throwable);
            }
        }
    }

    class Acceptor
    implements Runnable {
        private final ServerSocketChannel _channel;

        public Acceptor(ServerSocketChannel serverSocketChannel) {
            this._channel = serverSocketChannel;
        }

        @Override
        public void run() {
            try {
                SelectionKey selectionKey = this._channel.register(ManagedSelector.this._selector, 16, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} acceptor={}", new Object[]{this, selectionKey});
                }
            }
            catch (Throwable throwable) {
                ManagedSelector.this.closeNoExceptions(this._channel);
                LOG.warn(throwable);
            }
        }
    }

    private class DumpKeys
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<Object> _dumps;

        private DumpKeys(List<Object> list) {
            this._dumps = list;
        }

        @Override
        public void run() {
            Selector selector = ManagedSelector.this._selector;
            if (selector != null && selector.isOpen()) {
                Set<SelectionKey> set = selector.keys();
                this._dumps.add(selector + " keys=" + set.size());
                for (SelectionKey selectionKey : set) {
                    try {
                        this._dumps.add(String.format("SelectionKey@%x{i=%d}->%s", selectionKey.hashCode(), selectionKey.interestOps(), selectionKey.attachment()));
                    }
                    catch (Throwable throwable) {
                        LOG.ignore(throwable);
                    }
                }
            }
            this.latch.countDown();
        }

        public boolean await(long l, TimeUnit timeUnit) {
            try {
                return this.latch.await(l, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    private static interface Product
    extends Runnable {
    }

    private class SelectorProducer
    implements ExecutionStrategy.Producer {
        private Set<SelectionKey> _keys = Collections.emptySet();
        private Iterator<SelectionKey> _cursor = Collections.emptyIterator();

        private SelectorProducer() {
        }

        public Runnable produce() {
            do {
                Runnable runnable;
                if ((runnable = this.processSelected()) != null) {
                    return runnable;
                }
                Runnable runnable2 = this.runActions();
                if (runnable2 != null) {
                    return runnable2;
                }
                this.update();
            } while (this.select());
            return null;
        }

        private Runnable runActions() {
            while (true) {
                Runnable runnable;
                try (Locker.Lock lock = ManagedSelector.this._locker.lock();){
                    runnable = (Runnable)ManagedSelector.this._actions.poll();
                    if (runnable == null) {
                        ManagedSelector.this._selecting = true;
                        Runnable runnable2 = null;
                        return runnable2;
                    }
                }
                if (runnable instanceof Product) {
                    return runnable;
                }
                this.runChange(runnable);
            }
        }

        private void runChange(Runnable runnable) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running change {}", new Object[]{runnable});
                }
                runnable.run();
            }
            catch (Throwable throwable) {
                LOG.debug("Could not run change " + runnable, throwable);
            }
        }

        private boolean select() {
            block17: {
                try {
                    Selector selector = ManagedSelector.this._selector;
                    if (selector == null || !selector.isOpen()) break block17;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector loop waiting on select", new Object[0]);
                    }
                    int n = selector.select();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector loop woken up from select, {}/{} selected", new Object[]{n, selector.keys().size()});
                    }
                    try (Locker.Lock lock = ManagedSelector.this._locker.lock();){
                        ManagedSelector.this._selecting = false;
                    }
                    this._keys = selector.selectedKeys();
                    this._cursor = this._keys.iterator();
                    return true;
                }
                catch (Throwable throwable) {
                    ManagedSelector.this.closeNoExceptions(ManagedSelector.this._selector);
                    if (ManagedSelector.this.isRunning()) {
                        LOG.warn(throwable);
                    }
                    LOG.debug(throwable);
                }
            }
            return false;
        }

        private Runnable processSelected() {
            while (this._cursor.hasNext()) {
                Object object;
                SelectionKey selectionKey = this._cursor.next();
                if (selectionKey.isValid()) {
                    object = selectionKey.attachment();
                    try {
                        Runnable runnable;
                        if (object instanceof SelectableEndPoint) {
                            runnable = ((SelectableEndPoint)object).onSelected();
                            if (runnable == null) continue;
                            return runnable;
                        }
                        if (selectionKey.isConnectable()) {
                            runnable = ManagedSelector.this.processConnect(selectionKey, (Connect)object);
                            if (runnable == null) continue;
                            return runnable;
                        }
                        if (selectionKey.isAcceptable()) {
                            ManagedSelector.this.processAccept(selectionKey);
                            continue;
                        }
                        throw new IllegalStateException("key=" + selectionKey + ", att=" + object + ", iOps=" + selectionKey.interestOps() + ", rOps=" + selectionKey.readyOps());
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        LOG.debug("Ignoring cancelled key for channel {}", new Object[]{selectionKey.channel()});
                        if (!(object instanceof EndPoint)) continue;
                        ManagedSelector.this.closeNoExceptions((EndPoint)object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        LOG.warn("Could not process key for channel " + selectionKey.channel(), throwable);
                        if (!(object instanceof EndPoint)) continue;
                        ManagedSelector.this.closeNoExceptions((EndPoint)object);
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector loop ignoring invalid key for channel {}", new Object[]{selectionKey.channel()});
                }
                if (!((object = selectionKey.attachment()) instanceof EndPoint)) continue;
                ManagedSelector.this.closeNoExceptions((EndPoint)object);
            }
            return null;
        }

        private void update() {
            for (SelectionKey selectionKey : this._keys) {
                this.updateKey(selectionKey);
            }
            this._keys.clear();
        }

        private void updateKey(SelectionKey selectionKey) {
            Object object = selectionKey.attachment();
            if (object instanceof SelectableEndPoint) {
                ((SelectableEndPoint)object).updateKey();
            }
        }
    }

    public static interface SelectableEndPoint
    extends EndPoint {
        public Runnable onSelected();

        public void updateKey();
    }
}

