/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class IdleTimeout {
    private static final Logger LOG = Log.getLogger(IdleTimeout.class);
    private final Scheduler _scheduler;
    private final AtomicReference<Scheduler.Task> _timeout = new AtomicReference();
    private volatile long _idleTimeout;
    private volatile long _idleTimestamp = System.currentTimeMillis();
    private final Runnable _idleTask = new Runnable(){

        @Override
        public void run() {
            long l = IdleTimeout.this.checkIdleTimeout();
            if (l >= 0L) {
                IdleTimeout.this.scheduleIdleTimeout(l > 0L ? l : IdleTimeout.this.getIdleTimeout());
            }
        }
    };

    public IdleTimeout(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    public long getIdleFor() {
        return System.currentTimeMillis() - this.getIdleTimestamp();
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long l) {
        long l2 = this._idleTimeout;
        this._idleTimeout = l;
        if (l2 > 0L) {
            if (l2 <= l) {
                return;
            }
            this.deactivate();
        }
        if (this.isOpen()) {
            this.activate();
        }
    }

    public void notIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    private void scheduleIdleTimeout(long l) {
        Scheduler.Task task;
        Scheduler.Task task2 = null;
        if (this.isOpen() && l > 0L && this._scheduler != null) {
            task2 = this._scheduler.schedule(this._idleTask, l, TimeUnit.MILLISECONDS);
        }
        if ((task = (Scheduler.Task)this._timeout.getAndSet(task2)) != null) {
            task.cancel();
        }
    }

    public void onOpen() {
        this.activate();
    }

    private void activate() {
        if (this._idleTimeout > 0L) {
            this._idleTask.run();
        }
    }

    public void onClose() {
        this.deactivate();
    }

    private void deactivate() {
        Scheduler.Task task = this._timeout.getAndSet(null);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            long l = this.getIdleTimestamp();
            long l2 = this.getIdleTimeout();
            long l3 = System.currentTimeMillis() - l;
            long l4 = l2 - l3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} idle timeout check, elapsed: {} ms, remaining: {} ms", new Object[]{this, l3, l4});
            }
            if (l != 0L && l2 > 0L && l4 <= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} idle timeout expired", new Object[]{this});
                }
                try {
                    this.onIdleExpired(new TimeoutException("Idle timeout expired: " + l3 + "/" + l2 + " ms"));
                }
                finally {
                    this.notIdle();
                }
            }
            return l4 >= 0L ? l4 : 0L;
        }
        return -1L;
    }

    protected abstract void onIdleExpired(TimeoutException var1);

    public abstract boolean isOpen();
}

