/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ChannelEndPoint
extends AbstractEndPoint {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final SocketChannel _channel;
    private final Socket _socket;
    private volatile boolean _ishut;
    private volatile boolean _oshut;

    public ChannelEndPoint(Scheduler scheduler, SocketChannel socketChannel) {
        super(scheduler, (InetSocketAddress)socketChannel.socket().getLocalSocketAddress(), (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress());
        this._channel = socketChannel;
        this._socket = socketChannel.socket();
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    protected void shutdownInput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ishut {}", new Object[]{this});
        }
        this._ishut = true;
        if (this._oshut) {
            this.close();
        }
    }

    @Override
    public void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("oshut {}", new Object[]{this});
        }
        this._oshut = true;
        if (this._channel.isOpen()) {
            try {
                if (!this._socket.isOutputShutdown()) {
                    this._socket.shutdownOutput();
                }
            }
            catch (IOException iOException) {
                LOG.debug((Throwable)iOException);
            }
            finally {
                if (this._ishut) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this._oshut || !this._channel.isOpen() || this._socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this._ishut || !this._channel.isOpen() || this._socket.isInputShutdown();
    }

    @Override
    public void close() {
        super.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("close {}", new Object[]{this});
        }
        try {
            this._channel.close();
        }
        catch (IOException iOException) {
            LOG.debug((Throwable)iOException);
        }
        finally {
            this._ishut = true;
            this._oshut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer byteBuffer) {
        if (this._ishut) {
            return -1;
        }
        int n = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        try {
            int n2 = this._channel.read(byteBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("filled {} {}", new Object[]{n2, this});
            }
            if (n2 > 0) {
                this.notIdle();
            } else if (n2 == -1) {
                this.shutdownInput();
            }
            int n3 = n2;
            return n3;
        }
        catch (IOException iOException) {
            LOG.debug((Throwable)iOException);
            this.shutdownInput();
            int n4 = -1;
            return n4;
        }
        finally {
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)n);
        }
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) {
        long l = 0L;
        try {
            if (byteBufferArray.length == 1) {
                l = this._channel.write(byteBufferArray[0]);
            } else if (byteBufferArray.length > 1) {
                l = this._channel.write(byteBufferArray, 0, byteBufferArray.length);
            } else {
                for (ByteBuffer byteBuffer : byteBufferArray) {
                    if (!byteBuffer.hasRemaining()) continue;
                    int n = this._channel.write(byteBuffer);
                    if (n > 0) {
                        l += (long)n;
                    }
                    if (byteBuffer.hasRemaining()) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", new Object[]{l, this});
            }
        }
        catch (IOException iOException) {
            throw new EofException(iOException);
        }
        if (l > 0L) {
            this.notIdle();
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (BufferUtil.isEmpty((ByteBuffer)byteBuffer)) continue;
            return false;
        }
        return true;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    public Socket getSocket() {
        return this._socket;
    }

    @Override
    protected void onIncompleteFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void needsFillInterest() {
        throw new UnsupportedOperationException();
    }
}

