/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.BufferUtil;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    public static class Lease {
        private final ByteBufferPool byteBufferPool;
        private final List<ByteBuffer> buffers;
        private final List<Boolean> recycles;

        public Lease(ByteBufferPool byteBufferPool) {
            this.byteBufferPool = byteBufferPool;
            this.buffers = new ArrayList<ByteBuffer>();
            this.recycles = new ArrayList<Boolean>();
        }

        public ByteBuffer acquire(int n, boolean bl) {
            ByteBuffer byteBuffer = this.byteBufferPool.acquire(n, bl);
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            return byteBuffer;
        }

        public void append(ByteBuffer byteBuffer, boolean bl) {
            this.buffers.add(byteBuffer);
            this.recycles.add(bl);
        }

        public void insert(int n, ByteBuffer byteBuffer, boolean bl) {
            this.buffers.add(n, byteBuffer);
            this.recycles.add(n, bl);
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.buffers;
        }

        public long getTotalLength() {
            long l = 0L;
            for (int i = 0; i < this.buffers.size(); ++i) {
                l += (long)this.buffers.get(i).remaining();
            }
            return l;
        }

        public int getSize() {
            return this.buffers.size();
        }

        public void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                ByteBuffer byteBuffer = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.byteBufferPool.release(byteBuffer);
            }
            this.buffers.clear();
            this.recycles.clear();
        }
    }
}

