/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    static final Logger LOG = Log.getLogger(ByteArrayEndPoint.class);
    public static final InetSocketAddress NOIP = new InetSocketAddress(0);
    private static final ByteBuffer EOF = BufferUtil.allocate((int)0);
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            ByteArrayEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Locker _locker = new Locker();
    private final Queue<ByteBuffer> _inQ = new ArrayQueue();
    private ByteBuffer _out;
    private boolean _ishut;
    private boolean _oshut;
    private boolean _closed;
    private boolean _growOutput;

    public ByteArrayEndPoint() {
        this(null, 0L, null, null);
    }

    public ByteArrayEndPoint(byte[] byArray, int n) {
        this(null, 0L, byArray != null ? BufferUtil.toBuffer((byte[])byArray) : null, BufferUtil.allocate((int)n));
    }

    public ByteArrayEndPoint(String string, int n) {
        this(null, 0L, string != null ? BufferUtil.toBuffer((String)string) : null, BufferUtil.allocate((int)n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l) {
        this(scheduler, l, null, null);
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, byte[] byArray, int n) {
        this(scheduler, l, byArray != null ? BufferUtil.toBuffer((byte[])byArray) : null, BufferUtil.allocate((int)n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, String string, int n) {
        this(scheduler, l, string != null ? BufferUtil.toBuffer((String)string) : null, BufferUtil.allocate((int)n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        super(scheduler, NOIP, NOIP);
        if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
            this.addInput(byteBuffer);
        }
        this._out = byteBuffer2 == null ? BufferUtil.allocate((int)1024) : byteBuffer2;
        this.setIdleTimeout(l);
    }

    @Override
    protected void onIncompleteFlush() {
    }

    protected void execute(Runnable runnable) {
        new Thread(runnable, "BAEPoint-" + Integer.toHexString(this.hashCode())).start();
    }

    @Override
    protected void needsFillInterest() {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._closed) {
                throw new ClosedChannelException();
            }
            ByteBuffer byteBuffer = this._inQ.peek();
            if (BufferUtil.hasContent((ByteBuffer)byteBuffer) || byteBuffer == EOF) {
                this.execute(this._runFillable);
            }
        }
    }

    public void addInputEOF() {
        this.addInput((ByteBuffer)null);
    }

    public void addInput(ByteBuffer byteBuffer) {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._inQ.peek() == EOF) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean bl2 = this._inQ.isEmpty();
            if (byteBuffer == null) {
                this._inQ.add(EOF);
                bl = true;
            }
            if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
                this._inQ.add(byteBuffer);
                bl = bl2;
            }
        }
        if (bl) {
            this._runFillable.run();
        }
    }

    public void addInputAndExecute(ByteBuffer byteBuffer) {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._inQ.peek() == EOF) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean bl2 = this._inQ.isEmpty();
            if (byteBuffer == null) {
                this._inQ.add(EOF);
                bl = true;
            }
            if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
                this._inQ.add(byteBuffer);
                bl = bl2;
            }
        }
        if (bl) {
            this.execute(this._runFillable);
        }
    }

    public void addInput(String string) {
        this.addInput(BufferUtil.toBuffer((String)string, (Charset)StandardCharsets.UTF_8));
    }

    public void addInput(String string, Charset charset) {
        this.addInput(BufferUtil.toBuffer((String)string, (Charset)charset));
    }

    public ByteBuffer getOutput() {
        return this._out;
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    public String getOutputString(Charset charset) {
        return BufferUtil.toString((ByteBuffer)this._out, (Charset)charset);
    }

    public ByteBuffer takeOutput() {
        ByteBuffer byteBuffer = this._out;
        this._out = BufferUtil.allocate((int)byteBuffer.capacity());
        this.getWriteFlusher().completeWrite();
        return byteBuffer;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    public String takeOutputString(Charset charset) {
        ByteBuffer byteBuffer = this.takeOutput();
        return BufferUtil.toString((ByteBuffer)byteBuffer, (Charset)charset);
    }

    public void setOutput(ByteBuffer byteBuffer) {
        this._out = byteBuffer;
        this.getWriteFlusher().completeWrite();
    }

    @Override
    public boolean isOpen() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = !this._closed;
            return bl;
        }
    }

    @Override
    public boolean isInputShutdown() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._ishut || this._closed;
            return bl;
        }
    }

    @Override
    public boolean isOutputShutdown() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._oshut || this._closed;
            return bl;
        }
    }

    public void shutdownInput() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._ishut = true;
            if (this._oshut && !this._closed) {
                this._closed = true;
                bl = true;
            }
        }
        if (bl) {
            super.close();
        }
    }

    @Override
    public void shutdownOutput() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._oshut = true;
            if (this._ishut && !this._closed) {
                this._closed = true;
                bl = true;
            }
        }
        if (bl) {
            super.close();
        }
    }

    @Override
    public void close() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (!this._closed) {
                this._oshut = true;
                this._ishut = true;
                this._closed = true;
                bl = true;
            }
        }
        if (bl) {
            super.close();
        }
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    @Override
    public int fill(ByteBuffer byteBuffer) {
        int n = 0;
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            while (true) {
                if (this._closed) {
                    throw new EofException("CLOSED");
                }
                if (this._ishut) {
                    int n2 = -1;
                    return n2;
                }
                if (this._inQ.isEmpty()) {
                    break;
                }
                ByteBuffer byteBuffer2 = this._inQ.peek();
                if (byteBuffer2 == EOF) {
                    this._ishut = true;
                    if (this._oshut) {
                        this._closed = true;
                        bl = true;
                    }
                    n = -1;
                    break;
                }
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer2)) {
                    n = BufferUtil.append((ByteBuffer)byteBuffer, (ByteBuffer)byteBuffer2);
                    if (BufferUtil.isEmpty((ByteBuffer)byteBuffer2)) {
                        this._inQ.poll();
                    }
                    break;
                }
                this._inQ.poll();
            }
        }
        if (bl) {
            super.close();
        }
        if (n > 0) {
            this.notIdle();
        }
        return n;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._oshut) {
            throw new IOException("OSHUT");
        }
        boolean bl = true;
        boolean bl2 = true;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!BufferUtil.hasContent((ByteBuffer)byteBuffer)) continue;
            if (this._growOutput && byteBuffer.remaining() > BufferUtil.space((ByteBuffer)this._out)) {
                BufferUtil.compact((ByteBuffer)this._out);
                if (byteBuffer.remaining() > BufferUtil.space((ByteBuffer)this._out)) {
                    ByteBuffer byteBuffer2 = BufferUtil.allocate((int)(this._out.capacity() + byteBuffer.remaining() * 2));
                    BufferUtil.append((ByteBuffer)byteBuffer2, (ByteBuffer)this._out);
                    this._out = byteBuffer2;
                }
            }
            if (BufferUtil.append((ByteBuffer)this._out, (ByteBuffer)byteBuffer) > 0) {
                bl2 = false;
            }
            if (!BufferUtil.hasContent((ByteBuffer)byteBuffer)) continue;
            bl = false;
            break;
        }
        if (!bl2) {
            this.notIdle();
        }
        return bl;
    }

    public void reset() {
        this.getFillInterest().onClose();
        this.getWriteFlusher().onClose();
        this._ishut = false;
        this._oshut = false;
        this._closed = false;
        this._inQ.clear();
        BufferUtil.clear((ByteBuffer)this._out);
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean bl) {
        this._growOutput = bl;
    }
}

