/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class ArrayByteBufferPool
implements ByteBufferPool {
    private final int _min;
    private final Bucket[] _direct;
    private final Bucket[] _indirect;
    private final int _inc;

    public ArrayByteBufferPool() {
        this(0, 1024, 65536);
    }

    public ArrayByteBufferPool(int n, int n2, int n3) {
        if (n >= n2) {
            throw new IllegalArgumentException("minSize >= increment");
        }
        if (n3 % n2 != 0 || n2 >= n3) {
            throw new IllegalArgumentException("increment must be a divisor of maxSize");
        }
        this._min = n;
        this._inc = n2;
        this._direct = new Bucket[n3 / n2];
        this._indirect = new Bucket[n3 / n2];
        int n4 = 0;
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i] = new Bucket(n4 += this._inc);
            this._indirect[i] = new Bucket(n4);
        }
    }

    @Override
    public ByteBuffer acquire(int n, boolean bl) {
        ByteBuffer byteBuffer;
        Bucket bucket = this.bucketFor(n, bl);
        ByteBuffer byteBuffer2 = byteBuffer = bucket == null ? null : bucket._queue.poll();
        if (byteBuffer == null) {
            int n2 = bucket == null ? n : bucket._size;
            byteBuffer = bl ? BufferUtil.allocateDirect((int)n2) : BufferUtil.allocate((int)n2);
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        Bucket bucket;
        if (byteBuffer != null && (bucket = this.bucketFor(byteBuffer.capacity(), byteBuffer.isDirect())) != null) {
            BufferUtil.clear((ByteBuffer)byteBuffer);
            bucket._queue.offer(byteBuffer);
        }
    }

    public void clear() {
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i]._queue.clear();
            this._indirect[i]._queue.clear();
        }
    }

    private Bucket bucketFor(int n, boolean bl) {
        if (n <= this._min) {
            return null;
        }
        int n2 = (n - 1) / this._inc;
        if (n2 >= this._direct.length) {
            return null;
        }
        Bucket bucket = bl ? this._direct[n2] : this._indirect[n2];
        return bucket;
    }

    Bucket[] bucketsFor(boolean bl) {
        return bl ? this._direct : this._indirect;
    }

    public static class Bucket {
        public final int _size;
        public final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();

        Bucket(int n) {
            this._size = n;
        }

        public String toString() {
            return String.format("Bucket@%x{%d,%d}", this.hashCode(), this._size, this._queue.size());
        }
    }
}

