/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final long _created = System.currentTimeMillis();
    private final InetSocketAddress _local;
    private final InetSocketAddress _remote;
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected void needsFillInterest() {
            AbstractEndPoint.this.needsFillInterest();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlush() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        super(scheduler);
        this._local = inetSocketAddress;
        this._remote = inetSocketAddress2;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._local;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remote;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", new Object[]{this});
        }
        super.onOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", new Object[]{this});
        }
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void close() {
        this.onClose();
    }

    @Override
    public void fillInterested(Callback callback) {
        this.notIdle();
        this._fillInterest.register(callback);
    }

    @Override
    public boolean isFillInterested() {
        return this._fillInterest.isInterested();
    }

    @Override
    public void write(Callback callback, ByteBuffer ... byteBufferArray) {
        this._writeFlusher.write(callback, byteBufferArray);
    }

    protected abstract void onIncompleteFlush();

    protected abstract void needsFillInterest();

    public FillInterest getFillInterest() {
        return this._fillInterest;
    }

    protected WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    @Override
    protected void onIdleExpired(TimeoutException timeoutException) {
        Connection connection = this._connection;
        if (connection != null && !this._connection.onIdleExpired()) {
            return;
        }
        boolean bl = this.isOutputShutdown();
        boolean bl2 = this.isInputShutdown();
        boolean bl3 = this._fillInterest.onFail(timeoutException);
        boolean bl4 = this._writeFlusher.onFail(timeoutException);
        if (this.isOpen() && (bl || bl2) && !bl3 && !bl4) {
            this.close();
        } else {
            LOG.debug("Ignored idle endpoint {}", new Object[]{this});
        }
    }

    @Override
    public void upgrade(Connection connection) {
        Connection connection2 = this.getConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgrading from {} to {}", new Object[]{this, connection2, connection});
        }
        ByteBuffer byteBuffer = connection2 instanceof Connection.UpgradeFrom ? ((Connection.UpgradeFrom)connection2).onUpgradeFrom() : null;
        connection2.onClose();
        connection2.getEndPoint().setConnection(connection);
        if (connection instanceof Connection.UpgradeTo) {
            ((Connection.UpgradeTo)connection).onUpgradeTo(byteBuffer);
        } else if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
            throw new IllegalStateException();
        }
        connection.onOpen();
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        String string = clazz.getSimpleName();
        while (string.length() == 0 && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            string = clazz.getSimpleName();
        }
        return String.format("%s@%x{%s<->%d,%s,%s,%s,%s,%s,%d/%d,%s}", string, this.hashCode(), this.getRemoteAddress(), this.getLocalAddress().getPort(), this.isOpen() ? "Open" : "CLOSED", this.isInputShutdown() ? "ISHUT" : "in", this.isOutputShutdown() ? "OSHUT" : "out", this._fillInterest.toStateString(), this._writeFlusher.toStateString(), this.getIdleFor(), this.getIdleTimeout(), this.getConnection() == null ? null : this.getConnection().getClass().getSimpleName());
    }
}

