/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UriTemplatePathSpec
extends RegexPathSpec {
    private static final Logger LOG = Log.getLogger(UriTemplatePathSpec.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{(.*)\\}");
    private static final String VARIABLE_RESERVED = ":/?#[]@!$&'()*+,;=";
    private static final String VARIABLE_SYMBOLS = "-._";
    private static final Set<String> FORBIDDEN_SEGMENTS = new HashSet<String>();
    private String[] variables;

    public UriTemplatePathSpec(String string) {
        String string2;
        int n;
        Objects.requireNonNull(string, "Path Param Spec cannot be null");
        if ("".equals(string) || "/".equals(string)) {
            this.pathSpec = "/";
            this.pattern = Pattern.compile("^/$");
            this.pathDepth = 1;
            this.specLength = 1;
            this.variables = new String[0];
            this.group = PathSpecGroup.EXACT;
            return;
        }
        if (string.charAt(0) != '/') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Syntax Error: path spec \"");
            stringBuilder.append(string);
            stringBuilder.append("\" must start with '/'");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        for (String object2 : FORBIDDEN_SEGMENTS) {
            if (!string.contains(object2)) continue;
            StringBuilder stringArray = new StringBuilder();
            stringArray.append("Syntax Error: segment ");
            stringArray.append(object2);
            stringArray.append(" is forbidden in path spec: ");
            stringArray.append(string);
            throw new IllegalArgumentException(stringArray.toString());
        }
        this.pathSpec = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('^');
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        String[] stringArray = string.substring(1).split("/");
        char[] cArray = new char[stringArray.length];
        this.pathDepth = stringArray.length;
        for (n = 0; n < stringArray.length; ++n) {
            Object object;
            string2 = stringArray[n];
            Matcher matcher = VARIABLE_PATTERN.matcher(string2);
            if (matcher.matches()) {
                object = matcher.group(1);
                if (arrayList.contains(object)) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("Syntax Error: variable ");
                    stringBuilder2.append((String)object);
                    stringBuilder2.append(" is duplicated in path spec: ");
                    stringBuilder2.append(string);
                    throw new IllegalArgumentException(stringBuilder2.toString());
                }
                this.assertIsValidVariableLiteral((String)object);
                cArray[n] = 118;
                arrayList.add((CharSequence)object);
                stringBuilder.append("/([^/]+)");
                continue;
            }
            if (matcher.find(0)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Syntax Error: variable ");
                ((StringBuilder)object).append(matcher.group());
                ((StringBuilder)object).append(" must exist as entire path segment: ");
                ((StringBuilder)object).append(string);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            if (string2.indexOf(123) >= 0 || string2.indexOf(125) >= 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Syntax Error: invalid path segment /");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("/ variable declaration incomplete: ");
                ((StringBuilder)object).append(string);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            if (string2.indexOf(42) >= 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Syntax Error: path segment /");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("/ contains a wildcard symbol (not supported by this uri-template implementation): ");
                ((StringBuilder)object).append(string);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            cArray[n] = 101;
            stringBuilder.append('/');
            for (Object object2 : (Object)string2.toCharArray()) {
                if (object2 == 46 || object2 == 91 || object2 == 93 || object2 == 92) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append((char)object2);
            }
        }
        if (string.charAt(string.length() - 1) == '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append('$');
        this.pattern = Pattern.compile(stringBuilder.toString());
        n = arrayList.size();
        this.variables = arrayList.toArray(new String[n]);
        string2 = String.valueOf(cArray);
        this.group = Pattern.matches("^e*$", string2) ? PathSpecGroup.EXACT : (Pattern.matches("^e*v+", string2) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^v+e+", string2) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
    }

    private void assertIsValidVariableLiteral(String string) {
        boolean bl;
        int n = string.length();
        int n2 = 0;
        boolean bl2 = bl = n > 0;
        while (bl && n2 < n) {
            int n3 = string.codePointAt(n2);
            n2 += Character.charCount(n3);
            if (this.isValidBasicLiteralCodepoint(n3) || Character.isSupplementaryCodePoint(n3)) continue;
            if (n3 == 37) {
                if (n2 + 2 > n) {
                    bl = false;
                    continue;
                }
                n3 = TypeUtil.convertHexDigit((int)string.codePointAt(n2++)) << 4;
                if (this.isValidBasicLiteralCodepoint(n3 |= TypeUtil.convertHexDigit((int)string.codePointAt(n2++)))) continue;
            }
            bl = false;
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Syntax Error: variable {");
            stringBuilder.append(string);
            stringBuilder.append("} an invalid variable name: ");
            stringBuilder.append(this.pathSpec);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    private boolean isValidBasicLiteralCodepoint(int n) {
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57) {
            return true;
        }
        if (VARIABLE_SYMBOLS.indexOf(n) >= 0) {
            return true;
        }
        if (VARIABLE_RESERVED.indexOf(n) >= 0) {
            LOG.warn("Detected URI Template reserved symbol [{}] in path spec \"{}\"", new Object[]{Character.valueOf((char)n), this.pathSpec});
            return false;
        }
        return false;
    }

    public Map<String, String> getPathParams(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            if (this.group == PathSpecGroup.EXACT) {
                return Collections.emptyMap();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = matcher.groupCount();
            for (int i = 1; i <= n; ++i) {
                hashMap.put(this.variables[i - 1], matcher.group(i));
            }
            return hashMap;
        }
        return null;
    }

    public int getVariableCount() {
        return this.variables.length;
    }

    public String[] getVariables() {
        return this.variables;
    }

    static {
        FORBIDDEN_SEGMENTS.add("/./");
        FORBIDDEN_SEGMENTS.add("/../");
        FORBIDDEN_SEGMENTS.add("//");
    }
}

