/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;

public class ServletPathSpec
extends PathSpec {
    public ServletPathSpec(String string) {
        this.assertValidServletPathSpec(string);
        if (string == null || string.length() == 0) {
            this.pathSpec = "";
            this.pathDepth = -1;
            this.specLength = 1;
            this.group = PathSpecGroup.ROOT;
            return;
        }
        if ("/".equals(string)) {
            this.pathSpec = "/";
            this.pathDepth = -1;
            this.specLength = 1;
            this.group = PathSpecGroup.DEFAULT;
            return;
        }
        this.specLength = string.length();
        this.pathDepth = 0;
        char c = string.charAt(this.specLength - 1);
        this.group = string.charAt(0) == '/' && this.specLength > 1 && c == '*' ? PathSpecGroup.PREFIX_GLOB : (string.charAt(0) == '*' ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.EXACT);
        for (int i = 0; i < this.specLength; ++i) {
            int n = string.codePointAt(i);
            if (n >= 128) continue;
            char c2 = (char)n;
            switch (c2) {
                case '/': {
                    ++this.pathDepth;
                }
            }
        }
        this.pathSpec = string;
    }

    private void assertValidServletPathSpec(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        int n = string.length();
        if (string.charAt(0) == '/') {
            if (n == 1) {
                return;
            }
            int n2 = string.indexOf(42);
            if (n2 < 0) {
                return;
            }
            if (n2 != n - 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: glob '*' can only exist at end of prefix based matches: bad spec \"" + string + "\"");
            }
        } else if (string.startsWith("*.")) {
            int n3 = string.indexOf(47);
            if (n3 >= 0) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have path separators: bad spec \"" + string + "\"");
            }
            n3 = string.indexOf(42, 2);
            if (n3 >= 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have multiple glob '*': bad spec \"" + string + "\"");
            }
        } else {
            throw new IllegalArgumentException("Servlet Spec 12.2 violation: path spec must start with \"/\" or \"*.\": bad spec \"" + string + "\"");
        }
    }

    @Override
    public String getPathInfo(String string) {
        if (this.group == PathSpecGroup.PREFIX_GLOB) {
            if (string.length() == this.specLength - 2) {
                return null;
            }
            return string.substring(this.specLength - 2);
        }
        return null;
    }

    @Override
    public String getPathMatch(String string) {
        switch (this.group) {
            case EXACT: {
                if (this.pathSpec.equals(string)) {
                    return string;
                }
                return null;
            }
            case PREFIX_GLOB: {
                if (this.isWildcardMatch(string)) {
                    return string.substring(0, this.specLength - 2);
                }
                return null;
            }
            case SUFFIX_GLOB: {
                if (string.regionMatches(string.length() - (this.specLength - 1), this.pathSpec, 1, this.specLength - 1)) {
                    return string;
                }
                return null;
            }
            case DEFAULT: {
                return string;
            }
        }
        return null;
    }

    @Override
    public String getRelativePath(String string, String string2) {
        String string3 = this.getPathInfo(string2);
        if (string3 == null) {
            string3 = string2;
        }
        if (string3.startsWith("./")) {
            string3 = string3.substring(2);
        }
        string2 = string.endsWith("/") ? (string3.startsWith("/") ? string + string3.substring(1) : string + string3) : (string3.startsWith("/") ? string + string3 : string + "/" + string3);
        return string2;
    }

    private boolean isWildcardMatch(String string) {
        int n = this.specLength - 2;
        return this.group == PathSpecGroup.PREFIX_GLOB && string.regionMatches(0, this.pathSpec, 0, n) && (string.length() == n || '/' == string.charAt(n));
    }

    @Override
    public boolean matches(String string) {
        switch (this.group) {
            case EXACT: {
                return this.pathSpec.equals(string);
            }
            case PREFIX_GLOB: {
                return this.isWildcardMatch(string);
            }
            case SUFFIX_GLOB: {
                return string.regionMatches(string.length() - this.specLength + 1, this.pathSpec, 1, this.specLength - 1);
            }
            case ROOT: {
                return "/".equals(string);
            }
            case DEFAULT: {
                return true;
            }
        }
        return false;
    }
}

