/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;

public class RegexPathSpec
extends PathSpec {
    protected Pattern pattern;

    protected RegexPathSpec() {
    }

    public RegexPathSpec(String string) {
        this.pathSpec = string;
        boolean bl = false;
        this.pathDepth = 0;
        this.specLength = this.pathSpec.length();
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (char c : this.pathSpec.toCharArray()) {
            switch (c) {
                case '[': {
                    bl = true;
                    continue block6;
                }
                case ']': {
                    bl = false;
                    stringBuilder.append('g');
                    continue block6;
                }
                case '*': {
                    stringBuilder.append('g');
                    continue block6;
                }
                case '/': {
                    if (bl) continue block6;
                    ++this.pathDepth;
                    continue block6;
                }
                default: {
                    if (bl || !Character.isLetterOrDigit(c)) continue block6;
                    stringBuilder.append('l');
                }
            }
        }
        this.pattern = Pattern.compile(this.pathSpec);
        String string2 = stringBuilder.toString();
        this.group = Pattern.matches("^l*$", string2) ? PathSpecGroup.EXACT : (Pattern.matches("^l*g+", string2) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^g+l+$", string2) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
    }

    public Matcher getMatcher(String string) {
        return this.pattern.matcher(string);
    }

    @Override
    public String getPathInfo(String string) {
        Matcher matcher;
        if (this.group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(string)).matches() && matcher.groupCount() >= 1) {
            String string2 = matcher.group(1);
            if ("".equals(string2)) {
                return "/";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getPathMatch(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            int n;
            if (matcher.groupCount() >= 1 && (n = matcher.start(1)) > 0) {
                if (string.charAt(n - 1) == '/') {
                    --n;
                }
                return string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getRelativePath(String string, String string2) {
        return null;
    }

    @Override
    public boolean matches(String string) {
        int n = string.indexOf(63);
        if (n >= 0) {
            return this.getMatcher(string.substring(0, n)).matches();
        }
        return this.getMatcher(string).matches();
    }
}

