/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;

public class PathSpecSet
implements Set<String>,
Predicate<String> {
    private final Set<PathSpec> specs = new TreeSet<PathSpec>();

    @Override
    public boolean test(String string) {
        for (PathSpec pathSpec : this.specs) {
            if (!pathSpec.matches(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.specs.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private Iterator<PathSpec> iter;
            {
                this.iter = PathSpecSet.this.specs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                PathSpec pathSpec = this.iter.next();
                if (pathSpec == null) {
                    return null;
                }
                return pathSpec.getDeclaration();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported by this Iterator");
            }
        };
    }

    @Override
    public int size() {
        return this.specs.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof PathSpec) {
            return this.specs.contains(object);
        }
        if (object instanceof String) {
            return this.specs.contains(this.toPathSpec((String)object));
        }
        return false;
    }

    private PathSpec asPathSpec(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PathSpec) {
            return (PathSpec)object;
        }
        if (object instanceof String) {
            return this.toPathSpec((String)object);
        }
        return this.toPathSpec(object.toString());
    }

    private PathSpec toPathSpec(String string) {
        if (string == null || string.length() < 1) {
            throw new RuntimeException("Path Spec String must start with '^', '/', or '*.': got [" + string + "]");
        }
        if (string.charAt(0) == '^') {
            return new RegexPathSpec(string);
        }
        return new ServletPathSpec(string);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new String[this.specs.size()]);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = 0;
        for (PathSpec pathSpec : this.specs) {
            TArray[n++] = pathSpec.getDeclaration();
        }
        return TArray;
    }

    @Override
    public boolean add(String string) {
        return this.specs.add(this.toPathSpec(string));
    }

    @Override
    public boolean remove(Object object) {
        return this.specs.remove(this.asPathSpec(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.specs.contains(this.asPathSpec(obj))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        boolean bl = false;
        for (String string : collection) {
            bl |= this.add(string);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        ArrayList<PathSpec> arrayList = new ArrayList<PathSpec>();
        for (Object obj : collection) {
            arrayList.add(this.asPathSpec(obj));
        }
        return this.specs.retainAll(arrayList);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        ArrayList<PathSpec> arrayList = new ArrayList<PathSpec>();
        for (Object obj : collection) {
            arrayList.add(this.asPathSpec(obj));
        }
        return this.specs.removeAll(arrayList);
    }

    @Override
    public void clear() {
        this.specs.clear();
    }
}

