/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpecGroup;

public abstract class PathSpec
implements Comparable<PathSpec> {
    protected String pathSpec;
    protected PathSpecGroup group;
    protected int pathDepth;
    protected int specLength;

    @Override
    public int compareTo(PathSpec pathSpec) {
        int n = this.group.ordinal() - pathSpec.group.ordinal();
        if (n != 0) {
            return n;
        }
        n = pathSpec.specLength - this.specLength;
        if (n != 0) {
            return n;
        }
        return this.pathSpec.compareTo(pathSpec.pathSpec);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathSpec pathSpec = (PathSpec)object;
        return !(this.pathSpec == null ? pathSpec.pathSpec != null : !this.pathSpec.equals(pathSpec.pathSpec));
    }

    public PathSpecGroup getGroup() {
        return this.group;
    }

    public int getPathDepth() {
        return this.pathDepth;
    }

    public abstract String getPathInfo(String var1);

    public abstract String getPathMatch(String var1);

    public String getDeclaration() {
        return this.pathSpec;
    }

    public abstract String getRelativePath(String var1, String var2);

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.pathSpec == null ? 0 : this.pathSpec.hashCode());
        return n2;
    }

    public abstract boolean matches(String var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[\"");
        stringBuilder.append(this.pathSpec);
        stringBuilder.append("\",pathDepth=").append(this.pathDepth);
        stringBuilder.append(",group=").append((Object)this.group);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

