/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private List<MappedResource<E>> mappings = new ArrayList<MappedResource<E>>();
    private MappedResource<E> defaultResource = null;
    private MappedResource<E> rootResource = null;

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable appendable, String string) {
        ContainerLifeCycle.dump((Appendable)appendable, (String)string, (Collection[])new Collection[]{this.mappings});
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return this.mappings;
    }

    public void reset() {
        this.mappings.clear();
    }

    public List<MappedResource<E>> getMatches(String string) {
        boolean bl = "/".equals(string);
        ArrayList<MappedResource<MappedResource<E>>> arrayList = new ArrayList<MappedResource<MappedResource<E>>>();
        int n = this.mappings.size();
        block4: for (int i = 0; i < n; ++i) {
            MappedResource<E> mappedResource = this.mappings.get(i);
            switch (mappedResource.getPathSpec().group) {
                case ROOT: {
                    if (!bl) continue block4;
                    arrayList.add(mappedResource);
                    continue block4;
                }
                case DEFAULT: {
                    if (!bl && !mappedResource.getPathSpec().matches(string)) continue block4;
                    arrayList.add(mappedResource);
                    continue block4;
                }
                default: {
                    if (!mappedResource.getPathSpec().matches(string)) continue block4;
                    arrayList.add(mappedResource);
                }
            }
        }
        return arrayList;
    }

    public MappedResource<E> getMatch(String string) {
        if (string.equals("/") && this.rootResource != null) {
            return this.rootResource;
        }
        int n = this.mappings.size();
        for (int i = 0; i < n; ++i) {
            MappedResource<E> mappedResource = this.mappings.get(i);
            if (!mappedResource.getPathSpec().matches(string)) continue;
            return mappedResource;
        }
        return this.defaultResource;
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this.mappings.iterator();
    }

    public void put(PathSpec pathSpec, E e) {
        MappedResource<E> mappedResource = new MappedResource<E>(pathSpec, e);
        switch (pathSpec.group) {
            case DEFAULT: {
                this.defaultResource = mappedResource;
                break;
            }
            case ROOT: {
                this.rootResource = mappedResource;
            }
        }
        this.mappings.add(mappedResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added {} to {}", new Object[]{mappedResource, this});
        }
        Collections.sort(this.mappings);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this.mappings.size());
    }
}

