/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.jetty.http.Http1FieldPreEncoder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[2][];

    public PreEncodedHttpField(HttpHeader httpHeader, String string, String string2) {
        super(httpHeader, string, string2);
        HttpFieldPreEncoder[] httpFieldPreEncoderArray = __encoders;
        int n = httpFieldPreEncoderArray.length;
        for (int i = 0; i < n; ++i) {
            HttpFieldPreEncoder httpFieldPreEncoder;
            this._encodedField[(httpFieldPreEncoder = httpFieldPreEncoderArray[i]).getHttpVersion() == HttpVersion.HTTP_2 ? 1 : 0] = httpFieldPreEncoder.getEncodedField(httpHeader, httpHeader.asString(), string2);
        }
    }

    public PreEncodedHttpField(HttpHeader httpHeader, String string) {
        this(httpHeader, httpHeader.asString(), string);
    }

    public PreEncodedHttpField(String string, String string2) {
        this(null, string, string2);
    }

    public void putTo(ByteBuffer byteBuffer, HttpVersion httpVersion) {
        byteBuffer.put(this._encodedField[httpVersion == HttpVersion.HTTP_2 ? 1 : 0]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> arrayList = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iterator = ServiceLoader.load(HttpFieldPreEncoder.class, PreEncodedHttpField.class.getClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(iterator.next());
            }
            catch (Error | RuntimeException throwable) {
                LOG.debug(throwable);
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(new Http1FieldPreEncoder());
        }
        LOG.debug("HttpField encoders loaded: {}", new Object[]{arrayList});
        __encoders = arrayList.toArray(new HttpFieldPreEncoder[arrayList.size()]);
    }
}

