/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpVersion {
    HTTP_0_9("HTTP/0.9", 9),
    HTTP_1_0("HTTP/1.0", 10),
    HTTP_1_1("HTTP/1.1", 11),
    HTTP_2("HTTP/2.0", 20);

    public static final Trie<HttpVersion> CACHE;
    private final String _string;
    private final byte[] _bytes;
    private final ByteBuffer _buffer;
    private final int _version;

    public static HttpVersion lookAheadGet(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 9) {
            return null;
        }
        if (byArray[n + 4] == 47 && byArray[n + 6] == 46 && Character.isWhitespace((char)byArray[n + 8]) && (byArray[n] == 72 && byArray[n + 1] == 84 && byArray[n + 2] == 84 && byArray[n + 3] == 80 || byArray[n] == 104 && byArray[n + 1] == 116 && byArray[n + 2] == 116 && byArray[n + 3] == 112)) {
            switch (byArray[n + 5]) {
                case 49: {
                    switch (byArray[n + 7]) {
                        case 48: {
                            return HTTP_1_0;
                        }
                        case 49: {
                            return HTTP_1_1;
                        }
                    }
                    break;
                }
                case 50: {
                    switch (byArray[n + 7]) {
                        case 48: {
                            return HTTP_2;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HttpVersion lookAheadGet(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return HttpVersion.lookAheadGet(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
        return null;
    }

    private HttpVersion(String string2, int n2) {
        this._string = string2;
        this._bytes = StringUtil.getBytes((String)string2);
        this._buffer = ByteBuffer.wrap(this._bytes);
        this._version = n2;
    }

    public byte[] toBytes() {
        return this._bytes;
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public int getVersion() {
        return this._version;
    }

    public boolean is(String string) {
        return this._string.equalsIgnoreCase(string);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    public static HttpVersion fromString(String string) {
        return (HttpVersion)((Object)CACHE.get(string));
    }

    public static HttpVersion fromVersion(int n) {
        switch (n) {
            case 9: {
                return HTTP_0_9;
            }
            case 10: {
                return HTTP_1_0;
            }
            case 11: {
                return HTTP_1_1;
            }
            case 20: {
                return HTTP_2;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        CACHE = new ArrayTrie();
        for (HttpVersion httpVersion : HttpVersion.values()) {
            CACHE.put(httpVersion.toString(), (Object)httpVersion);
        }
    }
}

