/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpURI {
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    String _uri;
    String _decodedPath;

    public static HttpURI createHttpURI(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        if (n == 80 && HttpScheme.HTTP.is(string)) {
            n = 0;
        }
        if (n == 443 && HttpScheme.HTTPS.is(string)) {
            n = 0;
        }
        return new HttpURI(string, string2, n, string3, string4, string5, string6);
    }

    public HttpURI() {
    }

    public HttpURI(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        this._scheme = string;
        this._host = string2;
        this._port = n;
        this._path = string3;
        this._param = string4;
        this._query = string5;
        this._fragment = string6;
    }

    public HttpURI(HttpURI httpURI) {
        this(httpURI._scheme, httpURI._host, httpURI._port, httpURI._path, httpURI._param, httpURI._query, httpURI._fragment);
    }

    public HttpURI(String string) {
        this._port = -1;
        this.parse(State.START, string, 0, string.length());
    }

    public HttpURI(URI uRI) {
        int n;
        this._uri = null;
        this._scheme = uRI.getScheme();
        this._host = uRI.getHost();
        if (this._host == null && uRI.getRawSchemeSpecificPart().startsWith("//")) {
            this._host = "";
        }
        this._port = uRI.getPort();
        this._user = uRI.getUserInfo();
        this._path = uRI.getRawPath();
        this._decodedPath = uRI.getPath();
        if (this._decodedPath != null && (n = this._decodedPath.lastIndexOf(59)) >= 0) {
            this._param = this._decodedPath.substring(n + 1);
        }
        this._query = uRI.getRawQuery();
        this._fragment = uRI.getFragment();
        this._decodedPath = null;
    }

    public HttpURI(String string, String string2, int n, String string3) {
        this._uri = null;
        this._scheme = string;
        this._host = string2;
        this._port = n;
        this.parse(State.PATH, string3, 0, string3.length());
    }

    public void parse(String string) {
        this.clear();
        this._uri = string;
        this.parse(State.START, string, 0, string.length());
    }

    public void parseConnect(String string) {
        this.clear();
        this._uri = string;
        this._path = string;
    }

    public void parse(String string, int n, int n2) {
        this.clear();
        int n3 = n + n2;
        this._uri = string.substring(n, n3);
        this.parse(State.START, string, n, n3);
    }

    private void parse(State state, String string, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        int n4 = 0;
        block67: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            switch (state) {
                case START: {
                    switch (c) {
                        case '/': {
                            n3 = i;
                            state = State.HOST_OR_PATH;
                            continue block67;
                        }
                        case ';': {
                            n3 = i + 1;
                            state = State.PARAM;
                            continue block67;
                        }
                        case '?': {
                            this._path = "";
                            n3 = i + 1;
                            state = State.QUERY;
                            continue block67;
                        }
                        case '#': {
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            continue block67;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block67;
                        }
                    }
                    n3 = i;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block67;
                    }
                    n4 = i;
                    state = State.PATH;
                    continue block67;
                }
                case SCHEME_OR_PATH: {
                    switch (c) {
                        case ':': {
                            this._scheme = string.substring(n3, i);
                            state = State.START;
                            break;
                        }
                        case '/': {
                            state = State.PATH;
                            break;
                        }
                        case ';': {
                            n3 = i + 1;
                            state = State.PARAM;
                            break;
                        }
                        case '?': {
                            this._path = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '%': {
                            bl = true;
                            state = State.PATH;
                            break;
                        }
                        case '#': {
                            this._path = string.substring(n3, i);
                            state = State.FRAGMENT;
                        }
                    }
                    continue block67;
                }
                case HOST_OR_PATH: {
                    switch (c) {
                        case '/': {
                            this._host = "";
                            n3 = i + 1;
                            state = State.HOST;
                            continue block67;
                        }
                        case '#': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i;
                            n4 = n3;
                            state = State.PATH;
                            continue block67;
                        }
                    }
                    n4 = n3;
                    state = State.PATH;
                    continue block67;
                }
                case HOST: {
                    switch (c) {
                        case '/': {
                            this._host = string.substring(n3, i);
                            n4 = n3 = i;
                            state = State.PATH;
                            break;
                        }
                        case ':': {
                            if (i > n3) {
                                this._host = string.substring(n3, i);
                            }
                            n3 = i + 1;
                            state = State.PORT;
                            break;
                        }
                        case '@': {
                            this._user = string.substring(n3, i);
                            n3 = i + 1;
                            break;
                        }
                        case '[': {
                            state = State.IPV6;
                        }
                    }
                    continue block67;
                }
                case IPV6: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
                        }
                        case ']': {
                            c = string.charAt(++i);
                            this._host = string.substring(n3, i);
                            if (c == ':') {
                                n3 = i + 1;
                                state = State.PORT;
                                break;
                            }
                            n4 = n3 = i;
                            state = State.PATH;
                        }
                    }
                    continue block67;
                }
                case PORT: {
                    if (c != '/') continue block67;
                    this._port = TypeUtil.parseInt((String)string, (int)n3, (int)(i - n3), (int)10);
                    n4 = n3 = i;
                    state = State.PATH;
                    continue block67;
                }
                case PATH: {
                    switch (c) {
                        case ';': {
                            n3 = i + 1;
                            state = State.PARAM;
                            break;
                        }
                        case '?': {
                            this._path = string.substring(n4, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '#': {
                            this._path = string.substring(n4, i);
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            break;
                        }
                        case '%': {
                            bl = true;
                        }
                    }
                    continue block67;
                }
                case PARAM: {
                    switch (c) {
                        case '?': {
                            this._path = string.substring(n4, i);
                            this._param = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '#': {
                            this._path = string.substring(n4, i);
                            this._param = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            break;
                        }
                        case '/': {
                            bl = true;
                            state = State.PATH;
                            break;
                        }
                        case ';': {
                            n3 = i + 1;
                        }
                    }
                    continue block67;
                }
                case QUERY: {
                    if (c != '#') continue block67;
                    this._query = string.substring(n3, i);
                    n3 = i + 1;
                    state = State.FRAGMENT;
                    continue block67;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("only '*'");
                }
                case FRAGMENT: {
                    this._fragment = string.substring(n3, n2);
                    i = n2;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case SCHEME_OR_PATH: {
                this._path = string.substring(n3, n2);
                break;
            }
            case HOST_OR_PATH: {
                this._path = string.substring(n3, n2);
                break;
            }
            case HOST: {
                if (n2 <= n3) break;
                this._host = string.substring(n3, n2);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
            }
            case PORT: {
                this._port = TypeUtil.parseInt((String)string, (int)n3, (int)(n2 - n3), (int)10);
                break;
            }
            case ASTERISK: {
                break;
            }
            case FRAGMENT: {
                this._fragment = string.substring(n3, n2);
                break;
            }
            case PARAM: {
                this._path = string.substring(n4, n2);
                this._param = string.substring(n3, n2);
                break;
            }
            case PATH: {
                this._path = string.substring(n4, n2);
                break;
            }
            case QUERY: {
                this._query = string.substring(n3, n2);
            }
        }
        if (!bl) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        if (this._host != null && this._host.length() == 0) {
            return null;
        }
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getDecodedPath() {
        if (this._decodedPath == null && this._path != null) {
            this._decodedPath = URIUtil.decodePath((String)this._path);
        }
        return this._decodedPath;
    }

    public String getParam() {
        return this._param;
    }

    public String getQuery() {
        return this._query;
    }

    public boolean hasQuery() {
        return this._query != null && this._query.length() > 0;
    }

    public String getFragment() {
        return this._fragment;
    }

    public void decodeQueryTo(MultiMap<String> multiMap) {
        if (this._query == this._fragment) {
            return;
        }
        UrlEncoded.decodeUtf8To((String)this._query, multiMap);
    }

    public void decodeQueryTo(MultiMap<String> multiMap, String string) {
        this.decodeQueryTo(multiMap, Charset.forName(string));
    }

    public void decodeQueryTo(MultiMap<String> multiMap, Charset charset) {
        if (this._query == this._fragment) {
            return;
        }
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To((String)this._query, multiMap);
        } else {
            UrlEncoded.decodeTo((String)this._query, multiMap, (Charset)charset);
        }
    }

    public void clear() {
        this._uri = null;
        this._scheme = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._param = null;
        this._query = null;
        this._fragment = null;
        this._decodedPath = null;
    }

    public boolean isAbsolute() {
        return this._scheme != null && this._scheme.length() > 0;
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._scheme != null) {
                stringBuilder.append(this._scheme).append(':');
            }
            if (this._host != null) {
                stringBuilder.append("//");
                if (this._user != null) {
                    stringBuilder.append(this._user).append('@');
                }
                stringBuilder.append(this._host);
            }
            if (this._port > 0) {
                stringBuilder.append(':').append(this._port);
            }
            if (this._path != null) {
                stringBuilder.append(this._path);
            }
            if (this._query != null) {
                stringBuilder.append('?').append(this._query);
            }
            if (this._fragment != null) {
                stringBuilder.append('#').append(this._fragment);
            }
            this._uri = stringBuilder.length() > 0 ? stringBuilder.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public void setScheme(String string) {
        this._scheme = string;
        this._uri = null;
    }

    public void setAuthority(String string, int n) {
        this._host = string;
        this._port = n;
        this._uri = null;
    }

    public void setPath(String string) {
        this._uri = null;
        this._path = string;
        this._decodedPath = null;
    }

    public void setPathQuery(String string) {
        this._uri = null;
        this._path = null;
        this._decodedPath = null;
        this._param = null;
        this._fragment = null;
        if (string != null) {
            this.parse(State.PATH, string, 0, string.length());
        }
    }

    public void setQuery(String string) {
        this._query = string;
        this._uri = null;
    }

    public URI toURI() {
        return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString((String)this._query), this._fragment);
    }

    public String getPathQuery() {
        if (this._query == null) {
            return this._path;
        }
        return this._path + "?" + this._query;
    }

    public String getAuthority() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

