/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpParser {
    public static final Logger LOG = Log.getLogger(HttpParser.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpParser.STRICT");
    public static final int INITIAL_URI_LENGTH = 256;
    public static final Trie<HttpField> CACHE = new ArrayTrie(2048);
    private static final EnumSet<State> __idleStates = EnumSet.of(State.START, State.END, State.CLOSE, State.CLOSED);
    private static final EnumSet<State> __completeStates = EnumSet.of(State.END, State.CLOSE, State.CLOSED);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final HttpHandler _handler;
    private final RequestHandler _requestHandler;
    private final ResponseHandler _responseHandler;
    private final int _maxHeaderBytes;
    private final boolean _strict;
    private HttpField _field;
    private HttpHeader _header;
    private String _headerString;
    private HttpHeaderValue _value;
    private String _valueString;
    private int _responseStatus;
    private int _headerBytes;
    private boolean _host;
    private volatile State _state = State.START;
    private volatile boolean _eof;
    private HttpMethod _method;
    private String _methodString;
    private HttpVersion _version;
    private Utf8StringBuilder _uri = new Utf8StringBuilder(256);
    private HttpTokens.EndOfContent _endOfContent;
    private long _contentLength;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkPosition;
    private boolean _headResponse;
    private boolean _cr;
    private ByteBuffer _contentChunk;
    private Trie<HttpField> _connectionFields;
    private int _length;
    private final StringBuilder _string = new StringBuilder();
    private static final CharState[] __charState;

    public HttpParser(RequestHandler requestHandler) {
        this(requestHandler, -1, __STRICT);
    }

    public HttpParser(ResponseHandler responseHandler) {
        this(responseHandler, -1, __STRICT);
    }

    public HttpParser(RequestHandler requestHandler, int n) {
        this(requestHandler, n, __STRICT);
    }

    public HttpParser(ResponseHandler responseHandler, int n) {
        this(responseHandler, n, __STRICT);
    }

    public HttpParser(RequestHandler requestHandler, int n, boolean bl) {
        this._handler = requestHandler;
        this._requestHandler = requestHandler;
        this._responseHandler = null;
        this._maxHeaderBytes = n;
        this._strict = bl;
    }

    public HttpParser(ResponseHandler responseHandler, int n, boolean bl) {
        this._handler = responseHandler;
        this._requestHandler = null;
        this._responseHandler = responseHandler;
        this._maxHeaderBytes = n;
        this._strict = bl;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public void setHeadResponse(boolean bl) {
        this._headResponse = bl;
    }

    protected void setResponseStatus(int n) {
        this._responseStatus = n;
    }

    public State getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.END.ordinal();
    }

    public boolean inHeaderState() {
        return this._state.ordinal() < State.CONTENT.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isStart() {
        return this.isState(State.START);
    }

    public boolean isClose() {
        return this.isState(State.CLOSE);
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public boolean isIdle() {
        return __idleStates.contains((Object)this._state);
    }

    public boolean isComplete() {
        return __completeStates.contains((Object)this._state);
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private byte next(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        CharState charState = __charState[0xFF & by];
        switch (charState) {
            case ILLEGAL: {
                throw new IllegalCharacterException(this._state, by, byteBuffer);
            }
            case LF: {
                this._cr = false;
                break;
            }
            case CR: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                this._cr = true;
                if (byteBuffer.hasRemaining()) {
                    if (this._maxHeaderBytes > 0 && this._state.ordinal() < State.END.ordinal()) {
                        ++this._headerBytes;
                    }
                    return this.next(byteBuffer);
                }
                return 0;
            }
            case LEGAL: {
                if (!this._cr) break;
                throw new BadMessageException("Bad EOL");
            }
        }
        return by;
    }

    private boolean quickStart(ByteBuffer byteBuffer) {
        if (this._requestHandler != null) {
            this._method = HttpMethod.lookAheadGet(byteBuffer);
            if (this._method != null) {
                this._methodString = this._method.asString();
                byteBuffer.position(byteBuffer.position() + this._methodString.length() + 1);
                this.setState(State.SPACE1);
                return false;
            }
        } else if (this._responseHandler != null) {
            this._version = HttpVersion.lookAheadGet(byteBuffer);
            if (this._version != null) {
                byteBuffer.position(byteBuffer.position() + this._version.asString().length() + 1);
                this.setState(State.SPACE1);
                return false;
            }
        }
        while (this._state == State.START && byteBuffer.hasRemaining()) {
            byte by = this.next(byteBuffer);
            if (by > 32) {
                this._string.setLength(0);
                this._string.append((char)by);
                this.setState(this._requestHandler != null ? State.METHOD : State.RESPONSE_VERSION);
                return false;
            }
            if (by == 0) break;
            if (by < 0) {
                throw new BadMessageException();
            }
            if (this._maxHeaderBytes <= 0 || ++this._headerBytes <= this._maxHeaderBytes) continue;
            LOG.warn("padding is too large >" + this._maxHeaderBytes, new Object[0]);
            throw new BadMessageException(400);
        }
        return false;
    }

    private void setString(String string) {
        this._string.setLength(0);
        this._string.append(string);
        this._length = string.length();
    }

    private String takeString() {
        this._string.setLength(this._length);
        String string = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return string;
    }

    private boolean parseLine(ByteBuffer byteBuffer) {
        byte by;
        boolean bl = false;
        block10: while (this._state.ordinal() < State.HEADER.ordinal() && byteBuffer.hasRemaining() && !bl && (by = this.next(byteBuffer)) != 0) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                if (this._state == State.URI) {
                    LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                    throw new BadMessageException(414);
                }
                if (this._requestHandler != null) {
                    LOG.warn("request is too large >" + this._maxHeaderBytes, new Object[0]);
                } else {
                    LOG.warn("response is too large >" + this._maxHeaderBytes, new Object[0]);
                }
                throw new BadMessageException(413);
            }
            switch (this._state) {
                case METHOD: {
                    if (by == 32) {
                        this._length = this._string.length();
                        this._methodString = this.takeString();
                        HttpMethod httpMethod = (HttpMethod)((Object)HttpMethod.CACHE.get(this._methodString));
                        if (httpMethod != null && !this._strict) {
                            this._methodString = httpMethod.asString();
                        }
                        this.setState(State.SPACE1);
                        break;
                    }
                    if (by < 32) {
                        if (by == 10) {
                            throw new BadMessageException("No URI");
                        }
                        throw new IllegalCharacterException(this._state, by, byteBuffer);
                    }
                    this._string.append((char)by);
                    break;
                }
                case RESPONSE_VERSION: {
                    if (by == 32) {
                        this._length = this._string.length();
                        String string = this.takeString();
                        this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(string));
                        if (this._version == null) {
                            throw new BadMessageException(400, "Unknown Version");
                        }
                        this.setState(State.SPACE1);
                        break;
                    }
                    if (by < 32) {
                        throw new IllegalCharacterException(this._state, by, byteBuffer);
                    }
                    this._string.append((char)by);
                    break;
                }
                case SPACE1: {
                    int n;
                    int n2;
                    if (by > 32 || by < 0) {
                        if (this._responseHandler != null) {
                            this.setState(State.STATUS);
                            this.setResponseStatus(by - 48);
                            break;
                        }
                        this._uri.reset();
                        this.setState(State.URI);
                        if (byteBuffer.hasArray()) {
                            int n3;
                            byte[] byArray = byteBuffer.array();
                            n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                            n = byteBuffer.arrayOffset() + byteBuffer.limit();
                            for (n3 = n2; n3 < n && byArray[n3] > 32; ++n3) {
                            }
                            int n4 = n3 - n2;
                            this._headerBytes += n4;
                            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                                LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                                throw new BadMessageException(414);
                            }
                            this._uri.append(byArray, n2 - 1, n4 + 1);
                            byteBuffer.position(n3 - byteBuffer.arrayOffset());
                            break;
                        }
                        this._uri.append(by);
                        break;
                    }
                    if (by >= 32) continue block10;
                    throw new BadMessageException(400, this._requestHandler != null ? "No URI" : "No Status");
                }
                case STATUS: {
                    if (by == 32) {
                        this.setState(State.SPACE2);
                        break;
                    }
                    if (by >= 48 && by <= 57) {
                        this._responseStatus = this._responseStatus * 10 + (by - 48);
                        break;
                    }
                    if (by < 32 && by >= 0) {
                        bl = this._responseHandler.startResponse(this._version, this._responseStatus, null) || bl;
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new BadMessageException();
                }
                case URI: {
                    if (by == 32) {
                        this.setState(State.SPACE2);
                        break;
                    }
                    if (by < 32 && by >= 0) {
                        throw new BadMessageException("HTTP/0.9 not supported");
                    }
                    this._uri.append(by);
                    break;
                }
                case SPACE2: {
                    int n;
                    int n2;
                    if (by > 32) {
                        this._string.setLength(0);
                        this._string.append((char)by);
                        if (this._responseHandler != null) {
                            this._length = 1;
                            this.setState(State.REASON);
                            break;
                        }
                        this.setState(State.REQUEST_VERSION);
                        HttpVersion httpVersion = byteBuffer.position() > 0 && byteBuffer.hasArray() ? HttpVersion.lookAheadGet(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - 1, byteBuffer.arrayOffset() + byteBuffer.limit()) : (HttpVersion)((Object)HttpVersion.CACHE.getBest(byteBuffer, 0, byteBuffer.remaining()));
                        if (httpVersion == null || (n2 = byteBuffer.position() + httpVersion.asString().length() - 1) >= byteBuffer.limit()) continue block10;
                        n = byteBuffer.get(n2);
                        if (n == 13) {
                            this._cr = true;
                            this._version = httpVersion;
                            this._string.setLength(0);
                            byteBuffer.position(n2 + 1);
                            break;
                        }
                        if (n != 10) continue block10;
                        this._version = httpVersion;
                        this._string.setLength(0);
                        byteBuffer.position(n2);
                        break;
                    }
                    if (by == 10) {
                        if (this._responseHandler != null) {
                            bl = this._responseHandler.startResponse(this._version, this._responseStatus, null) || bl;
                            this.setState(State.HEADER);
                            break;
                        }
                        throw new BadMessageException("HTTP/0.9 not supported");
                    }
                    if (by >= 0) continue block10;
                    throw new BadMessageException();
                }
                case REQUEST_VERSION: {
                    if (by == 10) {
                        if (this._version == null) {
                            this._length = this._string.length();
                            this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(this.takeString()));
                        }
                        if (this._version == null) {
                            throw new BadMessageException(400, "Unknown Version");
                        }
                        if (this._connectionFields == null && this._version.getVersion() >= HttpVersion.HTTP_1_1.getVersion() && this._handler.getHeaderCacheSize() > 0) {
                            int n = this._handler.getHeaderCacheSize();
                            this._connectionFields = new ArrayTernaryTrie(n);
                        }
                        this.setState(State.HEADER);
                        bl = this._requestHandler.startRequest(this._methodString, this._uri.toString(), this._version) || bl;
                        continue block10;
                    }
                    if (by >= 32) {
                        this._string.append((char)by);
                        break;
                    }
                    throw new BadMessageException();
                }
                case REASON: {
                    if (by == 10) {
                        String string = this.takeString();
                        this.setState(State.HEADER);
                        bl = this._responseHandler.startResponse(this._version, this._responseStatus, string) || bl;
                        continue block10;
                    }
                    if (by >= 32) {
                        this._string.append((char)by);
                        if (by == 32 || by == 9) continue block10;
                        this._length = this._string.length();
                        break;
                    }
                    throw new BadMessageException();
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return bl;
    }

    private void parsedHeader() {
        if (this._headerString != null || this._valueString != null) {
            if (this._header != null) {
                boolean bl = false;
                switch (this._header) {
                    case CONTENT_LENGTH: {
                        if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) break;
                        try {
                            this._contentLength = Long.parseLong(this._valueString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOG.ignore((Throwable)numberFormatException);
                            throw new BadMessageException(400, "Bad Content-Length");
                        }
                        if (this._contentLength <= 0L) {
                            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            break;
                        }
                        this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                        break;
                    }
                    case TRANSFER_ENCODING: {
                        if (this._value == HttpHeaderValue.CHUNKED) {
                            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                            break;
                        }
                        if (this._valueString.endsWith(HttpHeaderValue.CHUNKED.toString())) {
                            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                            break;
                        }
                        if (!this._valueString.contains(HttpHeaderValue.CHUNKED.toString())) break;
                        throw new BadMessageException(400, "Bad chunking");
                    }
                    case HOST: {
                        this._host = true;
                        if (this._field instanceof HostPortHttpField) break;
                        this._field = new HostPortHttpField(this._header, this._strict ? this._headerString : this._header.asString(), this._valueString);
                        bl = this._connectionFields != null;
                        break;
                    }
                    case CONNECTION: {
                        if (this._valueString == null || !this._valueString.contains("close")) break;
                        this._connectionFields = null;
                        break;
                    }
                    case AUTHORIZATION: 
                    case ACCEPT: 
                    case ACCEPT_CHARSET: 
                    case ACCEPT_ENCODING: 
                    case ACCEPT_LANGUAGE: 
                    case COOKIE: 
                    case CACHE_CONTROL: 
                    case USER_AGENT: {
                        bl = this._connectionFields != null && this._field == null;
                        break;
                    }
                }
                if (bl && !this._connectionFields.isFull() && this._header != null && this._valueString != null) {
                    if (this._field == null) {
                        this._field = new HttpField(this._header, this._strict ? this._headerString : this._header.asString(), this._valueString);
                    }
                    this._connectionFields.put((Object)this._field);
                }
            }
            this._handler.parsedHeader(this._field != null ? this._field : new HttpField(this._header, this._headerString, this._valueString));
        }
        this._valueString = null;
        this._headerString = null;
        this._header = null;
        this._value = null;
        this._field = null;
    }

    protected boolean parseHeaders(ByteBuffer byteBuffer) {
        byte by;
        boolean bl = false;
        block15: while (this._state.ordinal() < State.CONTENT.ordinal() && byteBuffer.hasRemaining() && !bl && (by = this.next(byteBuffer)) != 0) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                LOG.warn("Header is too large >" + this._maxHeaderBytes, new Object[0]);
                throw new BadMessageException(413);
            }
            switch (this._state) {
                case HEADER: {
                    switch (by) {
                        case 9: 
                        case 32: 
                        case 58: {
                            throw new BadMessageException(400, "Bad Continuation");
                        }
                        case 10: {
                            this._contentPosition = 0L;
                            if (!this._host && this._version == HttpVersion.HTTP_1_1 && this._requestHandler != null) {
                                throw new BadMessageException(400, "No Host");
                            }
                            if (this._responseHandler != null && (this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200)) {
                                this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            } else if (this._endOfContent == HttpTokens.EndOfContent.UNKNOWN_CONTENT) {
                                this._endOfContent = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? HttpTokens.EndOfContent.NO_CONTENT : HttpTokens.EndOfContent.EOF_CONTENT;
                            }
                            switch (this._endOfContent) {
                                case EOF_CONTENT: {
                                    this.setState(State.EOF_CONTENT);
                                    bl = this._handler.headerComplete() || bl;
                                    return bl;
                                }
                                case CHUNKED_CONTENT: {
                                    this.setState(State.CHUNKED_CONTENT);
                                    bl = this._handler.headerComplete() || bl;
                                    return bl;
                                }
                                case NO_CONTENT: {
                                    bl = this._handler.headerComplete() || bl;
                                    this.setState(State.END);
                                    bl = this._handler.messageComplete() || bl;
                                    return bl;
                                }
                            }
                            this.setState(State.CONTENT);
                            bl = this._handler.headerComplete() || bl;
                            return bl;
                        }
                    }
                    if (by <= 32) {
                        throw new BadMessageException();
                    }
                    if (byteBuffer.hasRemaining()) {
                        HttpField httpField;
                        HttpField httpField2 = httpField = this._connectionFields == null ? null : (HttpField)this._connectionFields.getBest(byteBuffer, -1, byteBuffer.remaining());
                        if (httpField == null) {
                            httpField = (HttpField)CACHE.getBest(byteBuffer, -1, byteBuffer.remaining());
                        }
                        if (httpField != null) {
                            String string;
                            String string2;
                            if (this._strict) {
                                String string3 = httpField.getName();
                                String string4 = httpField.getValue();
                                string2 = BufferUtil.toString((ByteBuffer)byteBuffer, (int)(byteBuffer.position() - 1), (int)string3.length(), (Charset)StandardCharsets.US_ASCII);
                                if (string4 == null) {
                                    string = null;
                                } else {
                                    string = BufferUtil.toString((ByteBuffer)byteBuffer, (int)(byteBuffer.position() + string3.length() + 1), (int)string4.length(), (Charset)StandardCharsets.ISO_8859_1);
                                    httpField = new HttpField(httpField.getHeader(), string2, string);
                                }
                            } else {
                                string2 = httpField.getName();
                                string = httpField.getValue();
                            }
                            this._header = httpField.getHeader();
                            this._headerString = string2;
                            if (string == null) {
                                this.setState(State.HEADER_VALUE);
                                this._string.setLength(0);
                                this._length = 0;
                                byteBuffer.position(byteBuffer.position() + string2.length() + 1);
                                break;
                            }
                            int n = byteBuffer.position() + string2.length() + string.length() + 1;
                            byte by2 = byteBuffer.get(n);
                            if (by2 == 13 || by2 == 10) {
                                this._field = httpField;
                                this._valueString = string;
                                this.setState(State.HEADER_IN_VALUE);
                                if (by2 == 13) {
                                    this._cr = true;
                                    byteBuffer.position(n + 1);
                                    break;
                                }
                                byteBuffer.position(n);
                                break;
                            }
                            this.setState(State.HEADER_IN_VALUE);
                            this.setString(string);
                            byteBuffer.position(n);
                            break;
                        }
                    }
                    this.setState(State.HEADER_IN_NAME);
                    this._string.setLength(0);
                    this._string.append((char)by);
                    this._length = 1;
                    break;
                }
                case HEADER_IN_NAME: {
                    if (by == 58) {
                        if (this._headerString == null) {
                            this._headerString = this.takeString();
                            this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                        }
                        this._length = -1;
                        this.setState(State.HEADER_VALUE);
                        break;
                    }
                    if (by > 32) {
                        if (this._header != null) {
                            this.setString(this._header.asString());
                            this._header = null;
                            this._headerString = null;
                        }
                        this._string.append((char)by);
                        if (by <= 32) continue block15;
                        this._length = this._string.length();
                        break;
                    }
                    throw new IllegalCharacterException(this._state, by, byteBuffer);
                }
                case HEADER_VALUE: {
                    if (by > 32 || by < 0) {
                        this._string.append((char)(0xFF & by));
                        this._length = this._string.length();
                        this.setState(State.HEADER_IN_VALUE);
                        break;
                    }
                    if (by == 32) continue block15;
                    if (by == 9) break;
                    if (by == 10) {
                        this._value = null;
                        this._string.setLength(0);
                        this._valueString = null;
                        this._length = -1;
                        this.parsedHeader();
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new IllegalCharacterException(this._state, by, byteBuffer);
                }
                case HEADER_IN_VALUE: {
                    if (by >= 32 || by < 0 || by == 9) {
                        if (this._valueString != null) {
                            this.setString(this._valueString);
                            this._valueString = null;
                            this._field = null;
                        }
                        this._string.append((char)(0xFF & by));
                        if (by <= 32 && by >= 0) continue block15;
                        this._length = this._string.length();
                        break;
                    }
                    if (by == 10) {
                        if (this._length > 0) {
                            this._value = null;
                            this._valueString = this.takeString();
                            this._length = -1;
                        }
                        this.parsedHeader();
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new IllegalCharacterException(this._state, by, byteBuffer);
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return bl;
    }

    public boolean parseNext(ByteBuffer byteBuffer) {
        if (this.DEBUG) {
            LOG.debug("parseNext s={} {}", new Object[]{this._state, BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
        }
        try {
            if (this._state == State.START) {
                this._version = null;
                this._method = null;
                this._methodString = null;
                this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                this._header = null;
                if (this.quickStart(byteBuffer)) {
                    return true;
                }
            }
            if (this._state.ordinal() >= State.START.ordinal() && this._state.ordinal() < State.HEADER.ordinal() && this.parseLine(byteBuffer)) {
                return true;
            }
            if (this._state.ordinal() >= State.HEADER.ordinal() && this._state.ordinal() < State.CONTENT.ordinal() && this.parseHeaders(byteBuffer)) {
                return true;
            }
            if (this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.END.ordinal()) {
                if (this._responseStatus > 0 && this._headResponse) {
                    this.setState(State.END);
                    return this._handler.messageComplete();
                }
                if (this.parseContent(byteBuffer)) {
                    return true;
                }
            }
            if (this._state == State.END) {
                while (byteBuffer.remaining() > 0 && byteBuffer.get(byteBuffer.position()) <= 32) {
                    byteBuffer.get();
                }
            } else if (this._state == State.CLOSE) {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
                    this._headerBytes += byteBuffer.remaining();
                    BufferUtil.clear((ByteBuffer)byteBuffer);
                    if (this._maxHeaderBytes > 0 && this._headerBytes > this._maxHeaderBytes) {
                        throw new IllegalStateException("too much data seeking EOF");
                    }
                }
            } else if (this._state == State.CLOSED) {
                BufferUtil.clear((ByteBuffer)byteBuffer);
            }
            if (this._eof && !byteBuffer.hasRemaining()) {
                switch (this._state) {
                    case CLOSED: {
                        break;
                    }
                    case START: {
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    case END: 
                    case CLOSE: {
                        this.setState(State.CLOSED);
                        break;
                    }
                    case EOF_CONTENT: {
                        this.setState(State.CLOSED);
                        return this._handler.messageComplete();
                    }
                    case CONTENT: 
                    case CHUNKED_CONTENT: 
                    case CHUNK_SIZE: 
                    case CHUNK_PARAMS: 
                    case CHUNK: {
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    default: {
                        if (this.DEBUG) {
                            LOG.debug("{} EOF in {}", new Object[]{this, this._state});
                        }
                        this.setState(State.CLOSED);
                        this._handler.badMessage(400, null);
                    }
                }
            }
        }
        catch (BadMessageException badMessageException) {
            boolean bl;
            BufferUtil.clear((ByteBuffer)byteBuffer);
            Throwable throwable = badMessageException.getCause();
            boolean bl2 = bl = LOG.isDebugEnabled() || !(throwable instanceof NumberFormatException) && (throwable instanceof RuntimeException || throwable instanceof Error);
            if (bl) {
                LOG.warn("bad HTTP parsed: " + badMessageException._code + (badMessageException.getReason() != null ? " " + badMessageException.getReason() : "") + " for " + this._handler, (Throwable)badMessageException);
            } else {
                LOG.warn("bad HTTP parsed: " + badMessageException._code + (badMessageException.getReason() != null ? " " + badMessageException.getReason() : "") + " for " + this._handler, new Object[0]);
            }
            this.setState(State.CLOSE);
            this._handler.badMessage(badMessageException.getCode(), badMessageException.getReason());
        }
        catch (IllegalStateException | NumberFormatException runtimeException) {
            BufferUtil.clear((ByteBuffer)byteBuffer);
            LOG.warn("parse exception: {} in {} for {}", new Object[]{runtimeException.toString(), this._state, this._handler});
            if (this.DEBUG) {
                LOG.debug((Throwable)runtimeException);
            }
            switch (this._state) {
                case CLOSED: {
                    break;
                }
                case CLOSE: {
                    this._handler.earlyEOF();
                    break;
                }
                default: {
                    this.setState(State.CLOSE);
                    this._handler.badMessage(400, null);
                    break;
                }
            }
        }
        catch (Error | Exception throwable) {
            BufferUtil.clear((ByteBuffer)byteBuffer);
            LOG.warn("parse exception: " + throwable.toString() + " for " + this._handler, throwable);
            switch (this._state) {
                case CLOSED: {
                    break;
                }
                case CLOSE: {
                    this._handler.earlyEOF();
                    break;
                }
                default: {
                    this.setState(State.CLOSE);
                    this._handler.badMessage(400, null);
                }
            }
        }
        return false;
    }

    protected boolean parseContent(ByteBuffer byteBuffer) {
        long l;
        int n = byteBuffer.remaining();
        if (n == 0 && this._state == State.CONTENT && (l = this._contentLength - this._contentPosition) == 0L) {
            this.setState(State.END);
            return this._handler.messageComplete();
        }
        while (this._state.ordinal() < State.END.ordinal() && n > 0) {
            switch (this._state) {
                case EOF_CONTENT: {
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    this._contentPosition += (long)n;
                    byteBuffer.position(byteBuffer.position() + n);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case CONTENT: {
                    long l2 = this._contentLength - this._contentPosition;
                    if (l2 == 0L) {
                        this.setState(State.END);
                        return this._handler.messageComplete();
                    }
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    if ((long)n > l2) {
                        this._contentChunk.limit(this._contentChunk.position() + (int)l2);
                    }
                    this._contentPosition += (long)this._contentChunk.remaining();
                    byteBuffer.position(byteBuffer.position() + this._contentChunk.remaining());
                    if (this._handler.content(this._contentChunk)) {
                        return true;
                    }
                    if (this._contentPosition != this._contentLength) break;
                    this.setState(State.END);
                    return this._handler.messageComplete();
                }
                case CHUNKED_CONTENT: {
                    byte by = this.next(byteBuffer);
                    if (by <= 32) break;
                    this._chunkLength = TypeUtil.convertHexDigit((byte)by);
                    this._chunkPosition = 0;
                    this.setState(State.CHUNK_SIZE);
                    break;
                }
                case CHUNK_SIZE: {
                    byte by = this.next(byteBuffer);
                    if (by == 0) break;
                    if (by == 10) {
                        if (this._chunkLength == 0) {
                            this.setState(State.CHUNK_END);
                            break;
                        }
                        this.setState(State.CHUNK);
                        break;
                    }
                    if (by <= 32 || by == 59) {
                        this.setState(State.CHUNK_PARAMS);
                        break;
                    }
                    this._chunkLength = this._chunkLength * 16 + TypeUtil.convertHexDigit((byte)by);
                    break;
                }
                case CHUNK_PARAMS: {
                    byte by = this.next(byteBuffer);
                    if (by != 10) break;
                    if (this._chunkLength == 0) {
                        this.setState(State.CHUNK_END);
                        break;
                    }
                    this.setState(State.CHUNK);
                    break;
                }
                case CHUNK: {
                    int n2 = this._chunkLength - this._chunkPosition;
                    if (n2 == 0) {
                        this.setState(State.CHUNKED_CONTENT);
                        break;
                    }
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    if (n > n2) {
                        this._contentChunk.limit(this._contentChunk.position() + n2);
                    }
                    n2 = this._contentChunk.remaining();
                    this._contentPosition += (long)n2;
                    this._chunkPosition += n2;
                    byteBuffer.position(byteBuffer.position() + n2);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case CHUNK_END: {
                    byte by = this.next(byteBuffer);
                    if (by == 0) break;
                    if (by == 10) {
                        this.setState(State.END);
                        return this._handler.messageComplete();
                    }
                    throw new IllegalCharacterException(this._state, by, byteBuffer);
                }
                case CLOSED: {
                    BufferUtil.clear((ByteBuffer)byteBuffer);
                    return false;
                }
            }
            n = byteBuffer.remaining();
        }
        return false;
    }

    public boolean isAtEOF() {
        return this._eof;
    }

    public void atEOF() {
        if (this.DEBUG) {
            LOG.debug("atEOF {}", new Object[]{this});
        }
        this._eof = true;
    }

    public void close() {
        if (this.DEBUG) {
            LOG.debug("close {}", new Object[]{this});
        }
        this.setState(State.CLOSE);
    }

    public void reset() {
        if (this.DEBUG) {
            LOG.debug("reset {}", new Object[]{this});
        }
        if (this._state == State.CLOSE || this._state == State.CLOSED) {
            return;
        }
        this.setState(State.START);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._contentChunk = null;
        this._headerBytes = 0;
        this._host = false;
    }

    protected void setState(State state) {
        if (this.DEBUG) {
            LOG.debug("{} --> {}", new Object[]{this._state, state});
        }
        this._state = state;
    }

    public Trie<HttpField> getFieldCache() {
        return this._connectionFields;
    }

    private String getProxyField(ByteBuffer byteBuffer) {
        this._string.setLength(0);
        this._length = 0;
        while (byteBuffer.hasRemaining()) {
            byte by = this.next(byteBuffer);
            if (by <= 32) {
                return this._string.toString();
            }
            this._string.append((char)by);
        }
        throw new BadMessageException();
    }

    public String toString() {
        return String.format("%s{s=%s,%d of %d}", new Object[]{this.getClass().getSimpleName(), this._state, this._contentPosition, this._contentLength});
    }

    static {
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE));
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE));
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip,deflate,sdch"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-US,en;q=0.5"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-GB,en-US;q=0.8,en;q=0.6"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_CHARSET, "ISO-8859-1,utf-8;q=0.7,*;q=0.3"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "*/*"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "image/png,image/*;q=0.8,*/*;q=0.5"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        CACHE.put((Object)new HttpField(HttpHeader.PRAGMA, "no-cache"));
        CACHE.put((Object)new HttpField(HttpHeader.CACHE_CONTROL, "private, no-cache, no-cache=Set-Cookie, proxy-revalidate"));
        CACHE.put((Object)new HttpField(HttpHeader.CACHE_CONTROL, "no-cache"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_LENGTH, "0"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_ENCODING, "gzip"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_ENCODING, "deflate"));
        CACHE.put((Object)new HttpField(HttpHeader.TRANSFER_ENCODING, "chunked"));
        CACHE.put((Object)new HttpField(HttpHeader.EXPIRES, "Fri, 01 Jan 1990 00:00:00 GMT"));
        for (String string : new String[]{"text/plain", "text/html", "text/xml", "text/json", "application/json", "application/x-www-form-urlencoded"}) {
            PreEncodedHttpField preEncodedHttpField = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string);
            CACHE.put((Object)preEncodedHttpField);
            for (String string2 : new String[]{"utf-8", "iso-8859-1"}) {
                CACHE.put((Object)new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + ";charset=" + string2));
                CACHE.put((Object)new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + "; charset=" + string2));
                CACHE.put((Object)new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + ";charset=" + string2.toUpperCase()));
                CACHE.put((Object)new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + "; charset=" + string2.toUpperCase()));
            }
        }
        for (HttpHeader httpHeader : HttpHeader.values()) {
            if (CACHE.put((Object)new HttpField(httpHeader, (String)null))) continue;
            throw new IllegalStateException("CACHE FULL");
        }
        CACHE.put((Object)new HttpField(HttpHeader.REFERER, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.IF_MODIFIED_SINCE, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.IF_NONE_MATCH, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.AUTHORIZATION, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.COOKIE, (String)null));
        __charState = new CharState[256];
        Arrays.fill((Object[])__charState, (Object)CharState.ILLEGAL);
        HttpParser.__charState[10] = CharState.LF;
        HttpParser.__charState[13] = CharState.CR;
        HttpParser.__charState[9] = CharState.LEGAL;
        HttpParser.__charState[32] = CharState.LEGAL;
        HttpParser.__charState[33] = CharState.LEGAL;
        HttpParser.__charState[35] = CharState.LEGAL;
        HttpParser.__charState[36] = CharState.LEGAL;
        HttpParser.__charState[37] = CharState.LEGAL;
        HttpParser.__charState[38] = CharState.LEGAL;
        HttpParser.__charState[39] = CharState.LEGAL;
        HttpParser.__charState[42] = CharState.LEGAL;
        HttpParser.__charState[43] = CharState.LEGAL;
        HttpParser.__charState[45] = CharState.LEGAL;
        HttpParser.__charState[46] = CharState.LEGAL;
        HttpParser.__charState[94] = CharState.LEGAL;
        HttpParser.__charState[95] = CharState.LEGAL;
        HttpParser.__charState[96] = CharState.LEGAL;
        HttpParser.__charState[124] = CharState.LEGAL;
        HttpParser.__charState[126] = CharState.LEGAL;
        HttpParser.__charState[34] = CharState.LEGAL;
        HttpParser.__charState[92] = CharState.LEGAL;
        HttpParser.__charState[40] = CharState.LEGAL;
        HttpParser.__charState[41] = CharState.LEGAL;
        Arrays.fill((Object[])__charState, 33, 40, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 42, 92, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 93, 127, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 128, 256, (Object)CharState.LEGAL);
    }

    private static class IllegalCharacterException
    extends BadMessageException {
        private IllegalCharacterException(State state, byte by, ByteBuffer byteBuffer) {
            super(400, String.format("Illegal character 0x%X", by));
            LOG.warn(String.format("Illegal character 0x%X in state=%s for buffer %s", new Object[]{by, state, BufferUtil.toDetailString((ByteBuffer)byteBuffer)}), new Object[0]);
        }
    }

    public static interface ResponseHandler
    extends HttpHandler {
        public boolean startResponse(HttpVersion var1, int var2, String var3);
    }

    public static interface RequestHandler
    extends HttpHandler {
        public boolean startRequest(String var1, String var2, HttpVersion var3);
    }

    public static interface HttpHandler {
        public boolean content(ByteBuffer var1);

        public boolean headerComplete();

        public boolean messageComplete();

        public void parsedHeader(HttpField var1);

        public void earlyEOF();

        public void badMessage(int var1, String var2);

        public int getHeaderCacheSize();
    }

    static enum CharState {
        ILLEGAL,
        CR,
        LF,
        LEGAL;

    }

    public static enum State {
        START,
        METHOD,
        RESPONSE_VERSION,
        SPACE1,
        STATUS,
        URI,
        SPACE2,
        REQUEST_VERSION,
        REASON,
        PROXY,
        HEADER,
        HEADER_IN_NAME,
        HEADER_VALUE,
        HEADER_IN_VALUE,
        CONTENT,
        EOF_CONTENT,
        CHUNKED_CONTENT,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        CHUNK_END,
        END,
        CLOSE,
        CLOSED;

    }
}

