/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpMethod {
    GET,
    POST,
    HEAD,
    PUT,
    OPTIONS,
    DELETE,
    TRACE,
    CONNECT,
    MOVE,
    PROXY,
    PRI;

    public static final Trie<HttpMethod> CACHE;
    private final ByteBuffer _buffer;
    private final byte[] _bytes = StringUtil.getBytes((String)this.toString());

    public static HttpMethod lookAheadGet(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 4) {
            return null;
        }
        switch (byArray[n]) {
            case 71: {
                if (byArray[n + 1] != 69 || byArray[n + 2] != 84 || byArray[n + 3] != 32) break;
                return GET;
            }
            case 80: {
                if (byArray[n + 1] == 79 && byArray[n + 2] == 83 && byArray[n + 3] == 84 && n3 >= 5 && byArray[n + 4] == 32) {
                    return POST;
                }
                if (byArray[n + 1] == 82 && byArray[n + 2] == 79 && byArray[n + 3] == 88 && n3 >= 6 && byArray[n + 4] == 89 && byArray[n + 5] == 32) {
                    return PROXY;
                }
                if (byArray[n + 1] == 85 && byArray[n + 2] == 84 && byArray[n + 3] == 32) {
                    return PUT;
                }
                if (byArray[n + 1] != 82 || byArray[n + 2] != 73 || byArray[n + 3] != 32) break;
                return PRI;
            }
            case 72: {
                if (byArray[n + 1] != 69 || byArray[n + 2] != 65 || byArray[n + 3] != 68 || n3 < 5 || byArray[n + 4] != 32) break;
                return HEAD;
            }
            case 79: {
                if (byArray[n + 1] != 80 || byArray[n + 2] != 84 || byArray[n + 3] != 73 || n3 < 8 || byArray[n + 4] != 79 || byArray[n + 5] != 78 || byArray[n + 6] != 83 || byArray[n + 7] != 32) break;
                return OPTIONS;
            }
            case 68: {
                if (byArray[n + 1] != 69 || byArray[n + 2] != 76 || byArray[n + 3] != 69 || n3 < 7 || byArray[n + 4] != 84 || byArray[n + 5] != 69 || byArray[n + 6] != 32) break;
                return DELETE;
            }
            case 84: {
                if (byArray[n + 1] != 82 || byArray[n + 2] != 65 || byArray[n + 3] != 67 || n3 < 6 || byArray[n + 4] != 69 || byArray[n + 5] != 32) break;
                return TRACE;
            }
            case 67: {
                if (byArray[n + 1] != 79 || byArray[n + 2] != 78 || byArray[n + 3] != 78 || n3 < 8 || byArray[n + 4] != 69 || byArray[n + 5] != 67 || byArray[n + 6] != 84 || byArray[n + 7] != 32) break;
                return CONNECT;
            }
            case 77: {
                if (byArray[n + 1] != 79 || byArray[n + 2] != 86 || byArray[n + 3] != 69 || n3 < 5 || byArray[n + 4] != 32) break;
                return MOVE;
            }
        }
        return null;
    }

    public static HttpMethod lookAheadGet(ByteBuffer byteBuffer) {
        int n;
        HttpMethod httpMethod;
        if (byteBuffer.hasArray()) {
            return HttpMethod.lookAheadGet(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
        int n2 = byteBuffer.remaining();
        if (n2 >= 4 && (httpMethod = (HttpMethod)((Object)CACHE.getBest(byteBuffer, 0, n2))) != null && n2 > (n = httpMethod.asString().length()) && byteBuffer.get(byteBuffer.position() + n) == 32) {
            return httpMethod;
        }
        return null;
    }

    private HttpMethod() {
        this._buffer = ByteBuffer.wrap(this._bytes);
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public boolean is(String string) {
        return this.toString().equalsIgnoreCase(string);
    }

    public ByteBuffer asBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public String asString() {
        return this.toString();
    }

    public static HttpMethod fromString(String string) {
        return (HttpMethod)((Object)CACHE.get(string));
    }

    static {
        CACHE = new ArrayTrie();
        for (HttpMethod httpMethod : HttpMethod.values()) {
            CACHE.put(httpMethod.toString(), (Object)httpMethod);
        }
    }
}

