/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    private static final HttpHeaderValue[] CLOSE = new HttpHeaderValue[]{HttpHeaderValue.CLOSE};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    public static final int CHUNK_SIZE = 12;
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContent = false;
    private Boolean _persistent = null;
    private final int _send;
    private static final int SEND_SERVER = 1;
    private static final int SEND_XPOWEREDBY = 2;
    private static final Set<String> __assumedContentMethods = new HashSet<String>(Arrays.asList(HttpMethod.POST.asString(), HttpMethod.PUT.asString()));
    private boolean _needCRLF = false;
    private static final byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static final byte[] CONTENT_LENGTH_0 = StringUtil.getBytes((String)"Content-Length: 0\r\n");
    private static final byte[] CONNECTION_KEEP_ALIVE = StringUtil.getBytes((String)"Connection: keep-alive\r\n");
    private static final byte[] CONNECTION_CLOSE = StringUtil.getBytes((String)"Connection: close\r\n");
    private static final byte[] HTTP_1_1_SPACE = StringUtil.getBytes((String)((Object)((Object)HttpVersion.HTTP_1_1) + " "));
    private static final byte[] CRLF = StringUtil.getBytes((String)"\r\n");
    private static final byte[] TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes((String)"Transfer-Encoding: chunked\r\n");
    private static final byte[][] SEND = new byte[][]{new byte[0], StringUtil.getBytes((String)"Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes((String)"X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes((String)"Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
    private static final PreparedResponse[] __preprepared = new PreparedResponse[512];

    public static void setJettyVersion(String string) {
        HttpGenerator.SEND[1] = StringUtil.getBytes((String)("Server: " + string + "\r\n"));
        HttpGenerator.SEND[2] = StringUtil.getBytes((String)("X-Powered-By: " + string + "\r\n"));
        HttpGenerator.SEND[3] = StringUtil.getBytes((String)("Server: " + string + "\r\nX-Powered-By: " + string + "\r\n"));
    }

    public HttpGenerator() {
        this(false, false);
    }

    public HttpGenerator(boolean bl, boolean bl2) {
        this._send = (bl ? 1 : 0) | (bl2 ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContent = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
    }

    @Deprecated
    public boolean getSendServerVersion() {
        return (this._send & 1) != 0;
    }

    @Deprecated
    public void setSendServerVersion(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    public boolean isIdle() {
        return this._state == State.START;
    }

    public boolean isEnd() {
        return this._state == State.END;
    }

    public boolean isCommitted() {
        return this._state.ordinal() >= State.COMMITTED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isNoContent() {
        return this._noContent;
    }

    public void setPersistent(boolean bl) {
        this._persistent = bl;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this._persistent);
    }

    public boolean isWritten() {
        return this._contentPrepared > 0L;
    }

    public long getContentPrepared() {
        return this._contentPrepared;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(MetaData.Request request, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl) {
        switch (this._state) {
            case START: {
                if (request == null) {
                    return Result.NEED_INFO;
                }
                if (byteBuffer == null) {
                    return Result.NEED_HEADER;
                }
                if (this._persistent == null) {
                    this._persistent = request.getVersion().ordinal() > HttpVersion.HTTP_1_0.ordinal();
                    if (!this._persistent.booleanValue() && HttpMethod.CONNECT.is(request.getMethod())) {
                        this._persistent = true;
                    }
                }
                int n = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
                try {
                    this.generateRequestLine(request, byteBuffer);
                    if (request.getVersion() == HttpVersion.HTTP_0_9) {
                        throw new IllegalArgumentException("HTTP/0.9 not supported");
                    }
                    this.generateHeaders(request, byteBuffer, byteBuffer3, bl);
                    boolean bl2 = request.getFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (bl2) {
                        this._state = State.COMMITTED;
                    } else {
                        int n2 = BufferUtil.length((ByteBuffer)byteBuffer3);
                        if (n2 > 0) {
                            this._contentPrepared += (long)n2;
                            if (this.isChunking()) {
                                this.prepareChunk(byteBuffer, n2);
                            }
                        }
                        this._state = bl ? State.COMPLETING : State.COMMITTED;
                    }
                    Result result = Result.FLUSH;
                    return result;
                }
                catch (Exception exception) {
                    String string = exception instanceof BufferOverflowException ? "Request header too large" : exception.getMessage();
                    throw new IOException(string, exception);
                }
                finally {
                    BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)n);
                }
            }
            case COMMITTED: {
                int n = BufferUtil.length((ByteBuffer)byteBuffer3);
                if (n > 0) {
                    if (this.isChunking()) {
                        if (byteBuffer2 == null) {
                            return Result.NEED_CHUNK;
                        }
                        BufferUtil.clearToFill((ByteBuffer)byteBuffer2);
                        this.prepareChunk(byteBuffer2, n);
                        BufferUtil.flipToFlush((ByteBuffer)byteBuffer2, (int)0);
                    }
                    this._contentPrepared += (long)n;
                }
                if (bl) {
                    this._state = State.COMPLETING;
                }
                return n > 0 ? Result.FLUSH : Result.CONTINUE;
            }
            case COMPLETING: {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear((ByteBuffer)byteBuffer3);
                }
                if (this.isChunking()) {
                    if (byteBuffer2 == null) {
                        return Result.NEED_CHUNK;
                    }
                    BufferUtil.clearToFill((ByteBuffer)byteBuffer2);
                    this.prepareChunk(byteBuffer2, 0);
                    BufferUtil.flipToFlush((ByteBuffer)byteBuffer2, (int)0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
                this._state = State.END;
                return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
            }
            case END: {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear((ByteBuffer)byteBuffer3);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    public Result generateResponse(MetaData.Response response, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl) {
        return this.generateResponse(response, false, byteBuffer, byteBuffer2, byteBuffer3, bl);
    }

    public Result generateResponse(MetaData.Response response, boolean bl, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl2) {
        switch (this._state) {
            case START: {
                if (response == null) {
                    return Result.NEED_INFO;
                }
                switch (response.getVersion()) {
                    case HTTP_1_0: {
                        if (this._persistent != null) break;
                        this._persistent = Boolean.FALSE;
                        break;
                    }
                    case HTTP_1_1: {
                        if (this._persistent != null) break;
                        this._persistent = Boolean.TRUE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException((Object)((Object)response.getVersion()) + " not supported");
                    }
                }
                if (byteBuffer == null) {
                    return Result.NEED_HEADER;
                }
                int n = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
                try {
                    this.generateResponseLine(response, byteBuffer);
                    int n2 = response.getStatus();
                    if (n2 >= 100 && n2 < 200) {
                        this._noContent = true;
                        if (n2 != 101) {
                            byteBuffer.put(HttpTokens.CRLF);
                            this._state = State.COMPLETING_1XX;
                            Result result = Result.FLUSH;
                            return result;
                        }
                    } else if (n2 == 204 || n2 == 304) {
                        this._noContent = true;
                    }
                    this.generateHeaders(response, byteBuffer, byteBuffer3, bl2);
                    int n3 = BufferUtil.length((ByteBuffer)byteBuffer3);
                    if (n3 > 0) {
                        this._contentPrepared += (long)n3;
                        if (this.isChunking() && !bl) {
                            this.prepareChunk(byteBuffer, n3);
                        }
                    }
                    this._state = bl2 ? State.COMPLETING : State.COMMITTED;
                }
                catch (Exception exception) {
                    String string = exception instanceof BufferOverflowException ? "Response header too large" : exception.getMessage();
                    throw new IOException(string, exception);
                }
                finally {
                    BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)n);
                }
                return Result.FLUSH;
            }
            case COMMITTED: {
                int n = BufferUtil.length((ByteBuffer)byteBuffer3);
                if (n > 0) {
                    if (this.isChunking()) {
                        if (byteBuffer2 == null) {
                            return Result.NEED_CHUNK;
                        }
                        BufferUtil.clearToFill((ByteBuffer)byteBuffer2);
                        this.prepareChunk(byteBuffer2, n);
                        BufferUtil.flipToFlush((ByteBuffer)byteBuffer2, (int)0);
                    }
                    this._contentPrepared += (long)n;
                }
                if (bl2) {
                    this._state = State.COMPLETING;
                    return n > 0 ? Result.FLUSH : Result.CONTINUE;
                }
                return n > 0 ? Result.FLUSH : Result.DONE;
            }
            case COMPLETING_1XX: {
                this.reset();
                return Result.DONE;
            }
            case COMPLETING: {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear((ByteBuffer)byteBuffer3);
                }
                if (this.isChunking()) {
                    if (byteBuffer2 == null) {
                        return Result.NEED_CHUNK;
                    }
                    BufferUtil.clearToFill((ByteBuffer)byteBuffer2);
                    this.prepareChunk(byteBuffer2, 0);
                    BufferUtil.flipToFlush((ByteBuffer)byteBuffer2, (int)0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
                this._state = State.END;
                return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
            }
            case END: {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear((ByteBuffer)byteBuffer3);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private void prepareChunk(ByteBuffer byteBuffer, int n) {
        if (this._needCRLF) {
            BufferUtil.putCRLF((ByteBuffer)byteBuffer);
        }
        if (n > 0) {
            BufferUtil.putHexInt((ByteBuffer)byteBuffer, (int)n);
            BufferUtil.putCRLF((ByteBuffer)byteBuffer);
            this._needCRLF = true;
        } else {
            byteBuffer.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateRequestLine(MetaData.Request request, ByteBuffer byteBuffer) {
        byteBuffer.put(StringUtil.getBytes((String)request.getMethod()));
        byteBuffer.put((byte)32);
        byteBuffer.put(StringUtil.getBytes((String)request.getURIString()));
        byteBuffer.put((byte)32);
        byteBuffer.put(request.getVersion().toBytes());
        byteBuffer.put(HttpTokens.CRLF);
    }

    private void generateResponseLine(MetaData.Response response, ByteBuffer byteBuffer) {
        int n = response.getStatus();
        PreparedResponse preparedResponse = n < __preprepared.length ? __preprepared[n] : null;
        String string = response.getReason();
        if (preparedResponse != null) {
            if (string == null) {
                byteBuffer.put(preparedResponse._responseLine);
            } else {
                byteBuffer.put(preparedResponse._schemeCode);
                byteBuffer.put(this.getReasonBytes(string));
                byteBuffer.put(HttpTokens.CRLF);
            }
        } else {
            byteBuffer.put(HTTP_1_1_SPACE);
            byteBuffer.put((byte)(48 + n / 100));
            byteBuffer.put((byte)(48 + n % 100 / 10));
            byteBuffer.put((byte)(48 + n % 10));
            byteBuffer.put((byte)32);
            if (string == null) {
                byteBuffer.put((byte)(48 + n / 100));
                byteBuffer.put((byte)(48 + n % 100 / 10));
                byteBuffer.put((byte)(48 + n % 10));
            } else {
                byteBuffer.put(this.getReasonBytes(string));
            }
            byteBuffer.put(HttpTokens.CRLF);
        }
    }

    private byte[] getReasonBytes(String string) {
        if (string.length() > 1024) {
            string = string.substring(0, 1024);
        }
        byte[] byArray = StringUtil.getBytes((String)string);
        int n = byArray.length;
        while (n-- > 0) {
            if (byArray[n] != 13 && byArray[n] != 10) continue;
            byArray[n] = 63;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(MetaData metaData, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        int n;
        MetaData.Request request = metaData instanceof MetaData.Request ? (MetaData.Request)metaData : null;
        MetaData.Response response = metaData instanceof MetaData.Response ? (MetaData.Response)metaData : null;
        int n2 = this._send;
        HttpField httpField = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder = null;
        long l = metaData.getContentLength();
        HttpFields httpFields = metaData.getFields();
        if (httpFields != null) {
            n = httpFields.size();
            block19: for (int i = 0; i < n; ++i) {
                HttpField httpField2 = httpFields.getField(i);
                String string = httpField2.getValue();
                if (string == null || string.length() == 0) continue;
                HttpHeader httpHeader = httpField2.getHeader();
                if (httpHeader == null) {
                    HttpGenerator.putTo(httpField2, byteBuffer);
                    continue;
                }
                switch (httpHeader) {
                    case CONTENT_LENGTH: {
                        this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                        if (l >= 0L) continue block19;
                        l = Long.valueOf(httpField2.getValue());
                        continue block19;
                    }
                    case CONTENT_TYPE: {
                        bl4 = true;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block19;
                    }
                    case TRANSFER_ENCODING: {
                        if (metaData.getVersion() != HttpVersion.HTTP_1_1) continue block19;
                        httpField = httpField2;
                        continue block19;
                    }
                    case CONNECTION: {
                        int n3;
                        HttpHeaderValue[] httpHeaderValueArray;
                        if (request != null) {
                            HttpGenerator.putTo(httpField2, byteBuffer);
                        }
                        if (HttpHeaderValue.CLOSE.is(httpField2.getValue())) {
                            httpHeaderValueArray = CLOSE;
                        } else {
                            HttpHeaderValue[] httpHeaderValueArray2 = new HttpHeaderValue[1];
                            httpHeaderValueArray = httpHeaderValueArray2;
                            httpHeaderValueArray2[0] = (HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(httpField2.getValue()));
                        }
                        HttpHeaderValue[] httpHeaderValueArray3 = httpHeaderValueArray;
                        String[] stringArray = null;
                        if (httpHeaderValueArray3[0] == null && (stringArray = StringUtil.csvSplit((String)httpField2.getValue())).length > 0) {
                            httpHeaderValueArray3 = new HttpHeaderValue[stringArray.length];
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                httpHeaderValueArray3[n3] = (HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(stringArray[n3]));
                            }
                        }
                        block21: for (n3 = 0; n3 < httpHeaderValueArray3.length; ++n3) {
                            HttpHeaderValue httpHeaderValue = httpHeaderValueArray3[n3];
                            switch (httpHeaderValue == null ? HttpHeaderValue.UNKNOWN : httpHeaderValue) {
                                case UPGRADE: {
                                    byteBuffer.put(HttpHeader.CONNECTION.getBytesColonSpace()).put(HttpHeader.UPGRADE.getBytes());
                                    byteBuffer.put(CRLF);
                                    continue block21;
                                }
                                case CLOSE: {
                                    bl3 = true;
                                    this._persistent = false;
                                    if (response == null || this._endOfContent != HttpTokens.EndOfContent.UNKNOWN_CONTENT) continue block21;
                                    this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                                    continue block21;
                                }
                                case KEEP_ALIVE: {
                                    if (metaData.getVersion() != HttpVersion.HTTP_1_0) continue block21;
                                    bl2 = true;
                                    if (response == null) continue block21;
                                    this._persistent = true;
                                    continue block21;
                                }
                                default: {
                                    if (stringBuilder == null) {
                                        stringBuilder = new StringBuilder();
                                    } else {
                                        stringBuilder.append(',');
                                    }
                                    stringBuilder.append(stringArray == null ? httpField2.getValue() : stringArray[n3]);
                                }
                            }
                        }
                        continue block19;
                    }
                    case SERVER: {
                        n2 &= 0xFFFFFFFE;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block19;
                    }
                    default: {
                        HttpGenerator.putTo(httpField2, byteBuffer);
                    }
                }
            }
        }
        n = response != null ? response.getStatus() : -1;
        switch (this._endOfContent) {
            case UNKNOWN_CONTENT: {
                if (this._contentPrepared == 0L && response != null && this._noContent) {
                    this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                    break;
                }
                if (metaData.getContentLength() > 0L) {
                    this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                    if (response == null && l <= 0L && !bl4 || this._noContent) break;
                    byteBuffer.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
                    BufferUtil.putDecLong((ByteBuffer)byteBuffer, (long)l);
                    byteBuffer.put(HttpTokens.CRLF);
                    break;
                }
                if (bl) {
                    this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                    long l2 = this._contentPrepared + (long)BufferUtil.length((ByteBuffer)byteBuffer2);
                    if (l >= 0L && l != l2) {
                        throw new IllegalArgumentException("Content-Length header(" + l + ") != actual(" + l2 + ")");
                    }
                    this.putContentLength(byteBuffer, l2, bl4, request, response);
                    break;
                }
                this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                if (this.isPersistent() && metaData.getVersion().ordinal() >= HttpVersion.HTTP_1_1.ordinal()) break;
                this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                break;
            }
            case CONTENT_LENGTH: {
                this.putContentLength(byteBuffer, l, bl4, request, response);
                break;
            }
            case NO_CONTENT: {
                throw new IllegalStateException();
            }
            case EOF_CONTENT: {
                this._persistent = request != null;
                break;
            }
            case CHUNKED_CONTENT: {
                break;
            }
        }
        if (this.isChunking()) {
            if (httpField != null && !HttpHeaderValue.CHUNKED.toString().equalsIgnoreCase(httpField.getValue())) {
                String string = httpField.getValue();
                if (!string.endsWith(HttpHeaderValue.CHUNKED.toString())) throw new IllegalArgumentException("BAD TE");
                HttpGenerator.putTo(httpField, byteBuffer);
            } else {
                byteBuffer.put(TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT) {
            bl2 = false;
            this._persistent = false;
        }
        if (response != null) {
            if (!this.isPersistent() && (bl3 || metaData.getVersion().ordinal() > HttpVersion.HTTP_1_0.ordinal())) {
                if (stringBuilder == null) {
                    byteBuffer.put(CONNECTION_CLOSE);
                } else {
                    byteBuffer.put(CONNECTION_CLOSE, 0, CONNECTION_CLOSE.length - 2);
                    byteBuffer.put((byte)44);
                    byteBuffer.put(StringUtil.getBytes((String)stringBuilder.toString()));
                    byteBuffer.put(CRLF);
                }
            } else if (bl2) {
                if (stringBuilder == null) {
                    byteBuffer.put(CONNECTION_KEEP_ALIVE);
                } else {
                    byteBuffer.put(CONNECTION_KEEP_ALIVE, 0, CONNECTION_KEEP_ALIVE.length - 2);
                    byteBuffer.put((byte)44);
                    byteBuffer.put(StringUtil.getBytes((String)stringBuilder.toString()));
                    byteBuffer.put(CRLF);
                }
            } else if (stringBuilder != null) {
                byteBuffer.put(HttpHeader.CONNECTION.getBytesColonSpace());
                byteBuffer.put(StringUtil.getBytes((String)stringBuilder.toString()));
                byteBuffer.put(CRLF);
            }
        }
        if (n > 199) {
            byteBuffer.put(SEND[n2]);
        }
        byteBuffer.put(HttpTokens.CRLF);
    }

    private void putContentLength(ByteBuffer byteBuffer, long l, boolean bl, MetaData.Request request, MetaData.Response response) {
        if (l > 0L) {
            byteBuffer.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
            BufferUtil.putDecLong((ByteBuffer)byteBuffer, (long)l);
            byteBuffer.put(HttpTokens.CRLF);
        } else if (!this._noContent && (bl || response != null || request != null && __assumedContentMethods.contains(request.getMethod()))) {
            byteBuffer.put(CONTENT_LENGTH_0);
        }
    }

    public static byte[] getReasonBuffer(int n) {
        PreparedResponse preparedResponse;
        PreparedResponse preparedResponse2 = preparedResponse = n < __preprepared.length ? __preprepared[n] : null;
        if (preparedResponse != null) {
            return preparedResponse._reason;
        }
        return null;
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String string, ByteBuffer byteBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n' || c == ':') {
                byteBuffer.put((byte)63);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c));
        }
    }

    private static void putSanitisedValue(String string, ByteBuffer byteBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n') {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c));
        }
    }

    public static void putTo(HttpField httpField, ByteBuffer byteBuffer) {
        if (httpField instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)httpField).putTo(byteBuffer, HttpVersion.HTTP_1_0);
        } else {
            HttpHeader httpHeader = httpField.getHeader();
            if (httpHeader != null) {
                byteBuffer.put(httpHeader.getBytesColonSpace());
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            } else {
                HttpGenerator.putSanitisedName(httpField.getName(), byteBuffer);
                byteBuffer.put(__colon_space);
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            }
            BufferUtil.putCRLF((ByteBuffer)byteBuffer);
        }
    }

    public static void putTo(HttpFields httpFields, ByteBuffer byteBuffer) {
        for (HttpField httpField : httpFields) {
            if (httpField == null) continue;
            HttpGenerator.putTo(httpField, byteBuffer);
        }
        BufferUtil.putCRLF((ByteBuffer)byteBuffer);
    }

    static {
        int n = HttpVersion.HTTP_1_1.toString().length();
        for (int i = 0; i < __preprepared.length; ++i) {
            HttpStatus.Code code = HttpStatus.getCode(i);
            if (code == null) continue;
            String string = code.getMessage();
            byte[] byArray = new byte[n + 5 + string.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(byArray, 0, n);
            byArray[n + 0] = 32;
            byArray[n + 1] = (byte)(48 + i / 100);
            byArray[n + 2] = (byte)(48 + i % 100 / 10);
            byArray[n + 3] = (byte)(48 + i % 10);
            byArray[n + 4] = 32;
            for (int j = 0; j < string.length(); ++j) {
                byArray[n + 5 + j] = (byte)string.charAt(j);
            }
            byArray[n + 5 + string.length()] = 13;
            byArray[n + 6 + string.length()] = 10;
            HttpGenerator.__preprepared[i] = new PreparedResponse();
            HttpGenerator.__preprepared[i]._schemeCode = Arrays.copyOfRange(byArray, 0, n + 5);
            HttpGenerator.__preprepared[i]._reason = Arrays.copyOfRange(byArray, n + 5, byArray.length - 2);
            HttpGenerator.__preprepared[i]._responseLine = byArray;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

