/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    public static final String __separators = ", \t";
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    private static final Float __one = new Float("1.0");
    private static final Float __zero = new Float("0.0");
    private static final Trie<Float> __qualities = new ArrayTernaryTrie();

    public HttpFields() {
        this._fields = new HttpField[20];
    }

    public HttpFields(int n) {
        this._fields = new HttpField[n];
    }

    public HttpFields(HttpFields httpFields) {
        this._fields = Arrays.copyOf(httpFields._fields, httpFields._fields.length + 10);
        this._size = httpFields._size;
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new Itr();
    }

    public Set<String> getFieldNamesCollection() {
        HashSet<String> hashSet = new HashSet<String>(this._size);
        for (HttpField httpField : this) {
            if (httpField == null) continue;
            hashSet.add(httpField.getName());
        }
        return hashSet;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public HttpField getField(int n) {
        if (n >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[n];
    }

    public HttpField getField(HttpHeader httpHeader) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField;
        }
        return null;
    }

    public HttpField getField(String string) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.getName().equalsIgnoreCase(string)) continue;
            return httpField;
        }
        return null;
    }

    public boolean contains(HttpField httpField) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.isSameName(httpField) || !httpField2.contains(httpField.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader httpHeader, String string) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (httpField.getHeader() != httpHeader || !httpField.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (!httpField.getName().equalsIgnoreCase(string) || !httpField.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader httpHeader) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (httpField.getHeader() != httpHeader) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String string) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (!httpField.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getStringField(HttpHeader httpHeader) {
        return this.get(httpHeader);
    }

    public String get(HttpHeader httpHeader) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField.getValue();
        }
        return null;
    }

    @Deprecated
    public String getStringField(String string) {
        return this.get(string);
    }

    public String get(String string) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.getName().equalsIgnoreCase(string)) continue;
            return httpField.getValue();
        }
        return null;
    }

    public List<String> getValuesList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpField httpField : this) {
            if (!httpField.getName().equalsIgnoreCase(string)) continue;
            arrayList.add(httpField.getValue());
        }
        return arrayList;
    }

    public Enumeration<String> getValues(final String string) {
        for (int i = 0; i < this._size; ++i) {
            final HttpField httpField = this._fields[i];
            if (!httpField.getName().equalsIgnoreCase(string) || httpField.getValue() == null) continue;
            final int n = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = httpField;
                    this.i = n + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._size) {
                            this.field = HttpFields.this._fields[this.i++];
                            if (!this.field.getName().equalsIgnoreCase(string) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() {
                    if (this.hasMoreElements()) {
                        String string2 = this.field.getValue();
                        this.field = null;
                        return string2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List list = Collections.emptyList();
        return Collections.enumeration(list);
    }

    public Enumeration<String> getValues(String string, final String string2) {
        final Enumeration<String> enumeration = this.getValues(string);
        if (enumeration == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string == null) continue;
                    this.tok = new QuotedStringTokenizer(string, string2, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = (String)this.tok.nextElement();
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
        };
    }

    public void put(HttpField httpField) {
        boolean bl = false;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.isSameName(httpField)) continue;
            if (bl) {
                System.arraycopy(this._fields, n + 1, this._fields, n, --this._size - n);
                continue;
            }
            this._fields[n] = httpField;
            bl = true;
        }
        if (!bl) {
            this.add(httpField);
        }
    }

    public void put(String string, String string2) {
        if (string2 == null) {
            this.remove(string);
        } else {
            this.put(new HttpField(string, string2));
        }
    }

    public void put(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this.put(httpHeader, httpHeaderValue.toString());
    }

    public void put(HttpHeader httpHeader, String string) {
        if (string == null) {
            this.remove(httpHeader);
        } else {
            this.put(new HttpField(httpHeader, string));
        }
    }

    public void put(String string, List<String> list) {
        this.remove(string);
        for (String string2 : list) {
            if (string2 == null) continue;
            this.add(string, string2);
        }
    }

    public void add(String string, String string2) {
        if (string2 == null) {
            return;
        }
        HttpField httpField = new HttpField(string, string2);
        this.add(httpField);
    }

    public void add(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this.add(httpHeader, httpHeaderValue.toString());
    }

    public void add(HttpHeader httpHeader, String string) {
        if (string == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField httpField = new HttpField(httpHeader, string);
        this.add(httpField);
    }

    public HttpField remove(HttpHeader httpHeader) {
        HttpField httpField = null;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (httpField2.getHeader() != httpHeader) continue;
            httpField = httpField2;
            System.arraycopy(this._fields, n + 1, this._fields, n, --this._size - n);
        }
        return httpField;
    }

    public HttpField remove(String string) {
        HttpField httpField = null;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.getName().equalsIgnoreCase(string)) continue;
            httpField = httpField2;
            System.arraycopy(this._fields, n + 1, this._fields, n, --this._size - n);
        }
        return httpField;
    }

    public long getLongField(String string) {
        HttpField httpField = this.getField(string);
        return httpField == null ? -1L : httpField.getLongValue();
    }

    public long getDateField(String string) {
        HttpField httpField = this.getField(string);
        if (httpField == null) {
            return -1L;
        }
        String string2 = HttpFields.valueParameters(httpField.getValue(), null);
        if (string2 == null) {
            return -1L;
        }
        long l = DateParser.parseDate(string2);
        if (l == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + string2);
        }
        return l;
    }

    public void putLongField(HttpHeader httpHeader, long l) {
        String string = Long.toString(l);
        this.put(httpHeader, string);
    }

    public void putLongField(String string, long l) {
        String string2 = Long.toString(l);
        this.put(string, string2);
    }

    public void putDateField(HttpHeader httpHeader, long l) {
        String string = DateGenerator.formatDate(l);
        this.put(httpHeader, string);
    }

    public void putDateField(String string, long l) {
        String string2 = DateGenerator.formatDate(l);
        this.put(string, string2);
    }

    public void addDateField(String string, long l) {
        String string2 = DateGenerator.formatDate(l);
        this.add(string, string2);
    }

    public int hashCode() {
        int n = 0;
        for (HttpField httpField : this._fields) {
            n += httpField.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpFields)) {
            return false;
        }
        HttpFields httpFields = (HttpFields)object;
        if (this.size() != httpFields.size()) {
            return false;
        }
        block0: for (HttpField httpField : this) {
            for (HttpField httpField2 : httpFields) {
                if (!httpField.equals(httpField2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (HttpField httpField : this) {
                if (httpField == null) continue;
                String string = httpField.getName();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(": ");
                string = httpField.getValue();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("\r\n");
            }
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
            return exception.toString();
        }
    }

    public void clear() {
        this._size = 0;
    }

    public void add(HttpField httpField) {
        if (httpField != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = httpField;
        }
    }

    public void addAll(HttpFields httpFields) {
        for (int i = 0; i < httpFields._size; ++i) {
            this.add(httpFields._fields[i]);
        }
    }

    public void add(HttpFields httpFields) {
        if (httpFields == null) {
            return;
        }
        Enumeration<String> enumeration = httpFields.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Enumeration<String> enumeration2 = httpFields.getValues(string);
            while (enumeration2.hasMoreElements()) {
                this.add(string, enumeration2.nextElement());
            }
        }
    }

    public static String valueParameters(String string, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        if (map == null) {
            return string.substring(0, n).trim();
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(n), ";", false, true);
        while (quotedStringTokenizer.hasMoreTokens()) {
            String string2 = quotedStringTokenizer.nextToken();
            QuotedStringTokenizer quotedStringTokenizer2 = new QuotedStringTokenizer(string2, "= ");
            if (!quotedStringTokenizer2.hasMoreTokens()) continue;
            String string3 = quotedStringTokenizer2.nextToken();
            String string4 = null;
            if (quotedStringTokenizer2.hasMoreTokens()) {
                string4 = quotedStringTokenizer2.nextToken();
            }
            map.put(string3, string4);
        }
        return string.substring(0, n).trim();
    }

    public static Float getQuality(String string) {
        Float f;
        Serializable serializable;
        if (string == null) {
            return __zero;
        }
        int n = string.indexOf(";");
        if (n++ < 0 || n == string.length()) {
            return __one;
        }
        if (string.charAt(n++) == 'q' && (serializable = (Float)__qualities.get(string, ++n, string.length() - n)) != null) {
            return serializable;
        }
        serializable = new HashMap<String, String>(4);
        HttpFields.valueParameters(string, serializable);
        String string2 = (String)serializable.get("q");
        if (string2 == null) {
            string2 = "*";
        }
        if ((f = (Float)__qualities.get(string2)) == null) {
            try {
                f = new Float(string2);
            }
            catch (Exception exception) {
                f = __one;
            }
        }
        return f;
    }

    public static List<String> qualityList(Enumeration<String> enumeration) {
        Object object;
        Object object2;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.emptyList();
        }
        Object object3 = null;
        Object object4 = null;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = HttpFields.getQuality((String)object2);
            if (!((double)((Float)object).floatValue() >= 0.001)) continue;
            object3 = LazyList.add(object3, (Object)object2);
            object4 = LazyList.add(object4, (Object)object);
        }
        object2 = LazyList.getList(object3, (boolean)false);
        if (object2.size() < 2) {
            return object2;
        }
        object = LazyList.getList(object4, (boolean)false);
        Float f = __zero;
        int n = object2.size();
        while (n-- > 0) {
            Float f2 = (Float)object.get(n);
            if (f.compareTo(f2) > 0) {
                String string = (String)object2.get(n);
                object2.set(n, object2.get(n + 1));
                object2.set(n + 1, string);
                object.set(n, object.get(n + 1));
                object.set(n + 1, f2);
                f = __zero;
                n = object2.size();
                continue;
            }
            f = f2;
        }
        object.clear();
        return object2;
    }

    static {
        __qualities.put("*", (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    private class Itr
    implements Iterator<HttpField> {
        int _cursor;
        int _last = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            int n = this._cursor;
            if (n >= HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._cursor = n + 1;
            this._last = n;
            return HttpFields.this._fields[this._last];
        }

        @Override
        public void remove() {
            if (this._last < 0) {
                throw new IllegalStateException();
            }
            System.arraycopy(HttpFields.this._fields, this._last + 1, HttpFields.this._fields, this._last, --HttpFields.this._size - this._last);
            this._cursor = this._last;
            this._last = -1;
        }
    }
}

