/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.concurrent.TimeUnit;

public class HttpCookie {
    private final String _name;
    private final String _value;
    private final String _comment;
    private final String _domain;
    private final long _maxAge;
    private final String _path;
    private final boolean _secure;
    private final int _version;
    private final boolean _httpOnly;
    private final long _expiration;

    public HttpCookie(String string, String string2) {
        this(string, string2, -1L);
    }

    public HttpCookie(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, -1L, false, false);
    }

    public HttpCookie(String string, String string2, long l) {
        this(string, string2, null, null, l, false, false);
    }

    public HttpCookie(String string, String string2, String string3, String string4, long l, boolean bl, boolean bl2) {
        this(string, string2, string3, string4, l, bl, bl2, null, 0);
    }

    public HttpCookie(String string, String string2, String string3, String string4, long l, boolean bl, boolean bl2, String string5, int n) {
        this._name = string;
        this._value = string2;
        this._domain = string3;
        this._path = string4;
        this._maxAge = l;
        this._httpOnly = bl;
        this._secure = bl2;
        this._comment = string5;
        this._version = n;
        this._expiration = l < 0L ? -1L : System.nanoTime() + TimeUnit.SECONDS.toNanos(l);
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getComment() {
        return this._comment;
    }

    public String getDomain() {
        return this._domain;
    }

    public long getMaxAge() {
        return this._maxAge;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public int getVersion() {
        return this._version;
    }

    public boolean isHttpOnly() {
        return this._httpOnly;
    }

    public boolean isExpired(long l) {
        return this._expiration >= 0L && l >= this._expiration;
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append("=").append(this.getValue());
        if (this.getDomain() != null) {
            stringBuilder.append(";$Domain=").append(this.getDomain());
        }
        if (this.getPath() != null) {
            stringBuilder.append(";$Path=").append(this.getPath());
        }
        return stringBuilder.toString();
    }
}

