/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.StringUtil;

public class HostPortHttpField
extends HttpField {
    private final String _host;
    private final int _port;

    public HostPortHttpField(String string) {
        this(HttpHeader.HOST, HttpHeader.HOST.asString(), string);
    }

    public HostPortHttpField(HttpHeader httpHeader, String string, String string2) {
        super(httpHeader, string, string2);
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            if (string2.charAt(0) == '[') {
                int n = string2.lastIndexOf(93);
                if (n < 0) {
                    throw new BadMessageException(400, "Bad ipv6");
                }
                this._host = string2.substring(0, n + 1);
                if (string2.length() > n + 1) {
                    if (string2.charAt(n + 1) != ':') {
                        throw new BadMessageException(400, "Bad ipv6 port");
                    }
                    this._port = StringUtil.toInt((String)string2, (int)(n + 2));
                } else {
                    this._port = 0;
                }
            } else {
                int n = string2.lastIndexOf(58);
                if (n >= 0) {
                    this._host = string2.substring(0, n);
                    this._port = StringUtil.toInt((String)string2, (int)(n + 1));
                } else {
                    this._host = string2;
                    this._port = 0;
                }
            }
        }
        catch (BadMessageException badMessageException) {
            throw badMessageException;
        }
        catch (Exception exception) {
            throw new BadMessageException(400, "Bad HostPort", exception);
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }
}

