/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.jetty.util.StringUtil;

public class DateGenerator {
    private static final TimeZone __GMT = TimeZone.getTimeZone("GMT");
    static final String[] DAYS;
    static final String[] MONTHS;
    private static final ThreadLocal<DateGenerator> __dateGenerator;
    public static final String __01Jan1970;
    private final StringBuilder buf = new StringBuilder(32);
    private final GregorianCalendar gc = new GregorianCalendar(__GMT);

    public static String formatDate(long l) {
        return __dateGenerator.get().doFormatDate(l);
    }

    public static void formatCookieDate(StringBuilder stringBuilder, long l) {
        __dateGenerator.get().doFormatCookieDate(stringBuilder, l);
    }

    public static String formatCookieDate(long l) {
        StringBuilder stringBuilder = new StringBuilder(28);
        DateGenerator.formatCookieDate(stringBuilder, l);
        return stringBuilder.toString();
    }

    public String doFormatDate(long l) {
        this.buf.setLength(0);
        this.gc.setTimeInMillis(l);
        int n = this.gc.get(7);
        int n2 = this.gc.get(5);
        int n3 = this.gc.get(2);
        int n4 = this.gc.get(1);
        int n5 = n4 / 100;
        n4 %= 100;
        int n6 = this.gc.get(11);
        int n7 = this.gc.get(12);
        int n8 = this.gc.get(13);
        this.buf.append(DAYS[n]);
        this.buf.append(',');
        this.buf.append(' ');
        StringUtil.append2digits((StringBuilder)this.buf, (int)n2);
        this.buf.append(' ');
        this.buf.append(MONTHS[n3]);
        this.buf.append(' ');
        StringUtil.append2digits((StringBuilder)this.buf, (int)n5);
        StringUtil.append2digits((StringBuilder)this.buf, (int)n4);
        this.buf.append(' ');
        StringUtil.append2digits((StringBuilder)this.buf, (int)n6);
        this.buf.append(':');
        StringUtil.append2digits((StringBuilder)this.buf, (int)n7);
        this.buf.append(':');
        StringUtil.append2digits((StringBuilder)this.buf, (int)n8);
        this.buf.append(" GMT");
        return this.buf.toString();
    }

    public void doFormatCookieDate(StringBuilder stringBuilder, long l) {
        this.gc.setTimeInMillis(l);
        int n = this.gc.get(7);
        int n2 = this.gc.get(5);
        int n3 = this.gc.get(2);
        int n4 = this.gc.get(1);
        n4 %= 10000;
        int n5 = (int)(l / 1000L % 86400L);
        int n6 = n5 % 60;
        int n7 = (n5 /= 60) % 60;
        int n8 = n5 / 60;
        stringBuilder.append(DAYS[n]);
        stringBuilder.append(',');
        stringBuilder.append(' ');
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)n2);
        stringBuilder.append('-');
        stringBuilder.append(MONTHS[n3]);
        stringBuilder.append('-');
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)(n4 / 100));
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)(n4 % 100));
        stringBuilder.append(' ');
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)n8);
        stringBuilder.append(':');
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)n7);
        stringBuilder.append(':');
        StringUtil.append2digits((StringBuilder)stringBuilder, (int)n6);
        stringBuilder.append(" GMT");
    }

    static {
        __GMT.setID("GMT");
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __dateGenerator = new ThreadLocal<DateGenerator>(){

            @Override
            protected DateGenerator initialValue() {
                return new DateGenerator();
            }
        };
        __01Jan1970 = DateGenerator.formatDate(0L);
    }
}

