/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLocationAwareLog
implements Serializable,
Log {
    private static final long serialVersionUID = -2379157579039314822L;
    protected String name;
    private transient LocationAwareLogger logger;
    private static final String FQCN = SLF4JLocationAwareLog.class.getName();

    SLF4JLocationAwareLog(LocationAwareLogger locationAwareLogger) {
        this.logger = locationAwareLogger;
        this.name = locationAwareLogger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void trace(Object object) {
        this.logger.log(null, FQCN, 0, String.valueOf(object), null, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 0, String.valueOf(object), null, throwable);
    }

    public void debug(Object object) {
        this.logger.log(null, FQCN, 10, String.valueOf(object), null, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 10, String.valueOf(object), null, throwable);
    }

    public void info(Object object) {
        this.logger.log(null, FQCN, 20, String.valueOf(object), null, null);
    }

    public void info(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 20, String.valueOf(object), null, throwable);
    }

    public void warn(Object object) {
        this.logger.log(null, FQCN, 30, String.valueOf(object), null, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 30, String.valueOf(object), null, throwable);
    }

    public void error(Object object) {
        this.logger.log(null, FQCN, 40, String.valueOf(object), null, null);
    }

    public void error(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 40, String.valueOf(object), null, throwable);
    }

    public void fatal(Object object) {
        this.logger.log(null, FQCN, 40, String.valueOf(object), null, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.logger.log(null, FQCN, 40, String.valueOf(object), null, throwable);
    }

    protected Object readResolve() {
        Logger logger = LoggerFactory.getLogger((String)this.name);
        return new SLF4JLocationAwareLog((LocationAwareLogger)logger);
    }
}

