/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.smime.ess.ESSException;

public class SignedReceiptException
extends ESSException {
    public static final int NO_RECEIPT_REQUEST = 0;
    public static final int NOT_IN_RECEIPTS_FROM_LIST = 1;
    public static final int ML_RECEIPT_POLICY_VALUE_NONE = 2;
    public static final int NOT_A_FIRST_TIER_RECIPIENT = 3;
    public static final int RECEIPT_REQUEST_ATTRIBUTES_MISMATCH = 4;
    public static final int ATTRIBUTE_PARSING_ERROR = 5;
    protected int reason_;

    public SignedReceiptException() {
    }

    public SignedReceiptException(int n2) {
        super(SignedReceiptException.getReasonMsg(n2));
        this.reason_ = n2;
    }

    public SignedReceiptException(int n2, String string) {
        super(string);
        this.reason_ = n2;
    }

    public SignedReceiptException(String string) {
        super(string);
    }

    public int getReason() {
        return this.reason_;
    }

    public static String getReasonMsg(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "No signed receipt requested by the sender.";
                break;
            }
            case 1: {
                string = "No signed receipt requested from this recipient (not in receiptsFrom list).";
                break;
            }
            case 2: {
                string = "Mail list receipt policy directs to not send a receipt (MLReceiptPolicy value of none).";
                break;
            }
            case 3: {
                string = "Receipts only requested from first tier recipients.";
                break;
            }
            case 4: {
                string = "There are ReceiptRequest attributes in the SignedData layer that are not identical.";
                break;
            }
            case 5: {
                string = "Error parsing required attribute.";
                break;
            }
        }
        return string;
    }
}

